/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.core;

import LandLord.landlord.eldoutilities.configuration.ConfigFileWrapper;
import LandLord.landlord.eldoutilities.conversation.ConversationRequester;
import LandLord.landlord.eldoutilities.crossversion.ServerVersion;
import LandLord.landlord.eldoutilities.crossversion.builder.VersionFunctionBuilder;
import LandLord.landlord.eldoutilities.inventory.InventoryActionHandler;
import LandLord.landlord.eldoutilities.scheduling.DelayedActions;
import LandLord.landlord.eldoutilities.serialization.util.PluginSerializationName;
import LandLord.landlord.eldoutilities.serialization.wrapper.ArmorStandWrapper;
import LandLord.landlord.eldoutilities.serialization.wrapper.MapEntry;
import LandLord.landlord.eldoutilities.threading.AsyncSyncingCallbackExecutor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;

public final class EldoUtilities {
    private static Plugin mainOwner;
    private static Map<Class<? extends Plugin>, Plugin> instanceOwners;
    private static DelayedActions delayedActions;
    private static InventoryActionHandler inventoryActionHandler;
    private static AsyncSyncingCallbackExecutor asyncSyncingCallbackExecutor;
    private static ConversationRequester conversationRequester;
    private static ConfigFileWrapper configuration;

    private EldoUtilities() {
    }

    public static Logger logger() {
        return Bukkit.getLogger();
    }

    public static void preWarm(Plugin eldoPlugin) {
        instanceOwners.put(eldoPlugin.getClass(), eldoPlugin);
        for (Class<? extends ConfigurationSerializable> clazz : EldoUtilities.getConfigSerialization()) {
            if (clazz.isAnnotationPresent(PluginSerializationName.class)) {
                PluginSerializationName annotation = clazz.getAnnotation(PluginSerializationName.class);
                ConfigurationSerialization.registerClass(clazz, (String)annotation.value().replace("{plugin}", eldoPlugin.getName().toLowerCase(Locale.ROOT)));
                continue;
            }
            ConfigurationSerialization.registerClass(clazz);
        }
    }

    public static void ignite(Plugin plugin) {
        VersionFunctionBuilder.functionBuilder(null, null).addVersionFunctionBetween(ServerVersion.MC_1_13, ServerVersion.MC_1_17, a -> {
            Bukkit.getScheduler().runTaskLater(plugin, () -> EldoUtilities.performLateCleanUp(plugin), 5L);
            return null;
        });
        Path path = Bukkit.getUpdateFolderFile().toPath().toAbsolutePath().getParent().resolve(Paths.get("EldoUtilities", "config.yml"));
        configuration = ConfigFileWrapper.forFile(plugin, path);
    }

    private static void performLateCleanUp(Plugin plugin) {
        Iterator bossBars = Bukkit.getBossBars();
        while (bossBars.hasNext()) {
            KeyedBossBar bar = (KeyedBossBar)bossBars.next();
            NamespacedKey key = bar.getKey();
            if (!key.getNamespace().equalsIgnoreCase(plugin.getName()) || !key.getKey().startsWith("messageChannel")) continue;
            EldoUtilities.logger().config("Removed boss bar with key" + key);
            bar.removeAll();
            Bukkit.removeBossBar((NamespacedKey)key);
        }
    }

    public static void shutdown() {
        if (delayedActions != null) {
            delayedActions.shutdown();
            delayedActions = null;
        }
        if (asyncSyncingCallbackExecutor != null) {
            asyncSyncingCallbackExecutor.shutdown();
            asyncSyncingCallbackExecutor = null;
        }
        if (inventoryActionHandler != null) {
            inventoryActionHandler = null;
        }
        if (conversationRequester != null) {
            conversationRequester = null;
        }
    }

    public static List<Class<? extends ConfigurationSerializable>> getConfigSerialization() {
        return Arrays.asList(MapEntry.class, ArmorStandWrapper.class, LandLord.landlord.eldoutilities.serialization.util.MapEntry.class, LandLord.landlord.eldoutilities.serialization.util.ArmorStandWrapper.class);
    }

    public static ConfigFileWrapper getConfiguration() {
        if (configuration == null) {
            Path config = Bukkit.getUpdateFolderFile().toPath().toAbsolutePath().getParent().resolve(Paths.get("EldoUtilities", "config.yml"));
            configuration = ConfigFileWrapper.forFile(config);
        }
        return configuration;
    }

    public static Plugin getInstanceOwner(Class<? extends Plugin> plugin) {
        return instanceOwners.get(plugin);
    }

    public static void forceInstanceOwner(Plugin plugin) {
        if (mainOwner != null) {
            throw new IllegalStateException("A instance owner is already set");
        }
        mainOwner = plugin;
    }

    public static Plugin getInstanceOwner() {
        if (mainOwner != null) {
            return mainOwner;
        }
        Iterator<Map.Entry<Class<? extends Plugin>, Plugin>> iterator = instanceOwners.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Class<? extends Plugin>, Plugin> entry = iterator.next();
            return entry.getValue();
        }
        throw new IllegalStateException("No instance owner is set but requested");
    }

    static {
        instanceOwners = new LinkedHashMap<Class<? extends Plugin>, Plugin>();
    }
}

