/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.conversation;

import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.messages.MessageSender;
import LandLord.landlord.eldoutilities.messages.MessageType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EldoConversation
extends Conversation {
    private final ILocalizer localizer;
    private final MessageSender sender;
    private final MessageType messageType;
    private final String userPrefix;
    private final String pluginPrefix;

    public EldoConversation(@Nullable Plugin plugin, @NotNull Conversable forWhom, @Nullable Prompt firstPrompt, @NotNull Map<Object, Object> initialSessionData, String pluginPrefix, String userPrefix, MessageType messageType) {
        super(plugin, forWhom, firstPrompt, initialSessionData);
        this.messageType = messageType;
        this.localizer = ILocalizer.getPluginLocalizer(plugin);
        this.sender = MessageSender.getPluginMessageSender(plugin);
        this.pluginPrefix = pluginPrefix == null ? this.sender.getPrefix() : pluginPrefix;
        this.userPrefix = userPrefix == null ? "" : userPrefix;
    }

    public static Builder builder(Plugin plugin, Conversable forWhom, Prompt firstPrompt) {
        return new Builder(plugin, forWhom, firstPrompt);
    }

    void addConversationCanceller(@NotNull ConversationCanceller canceller) {
        canceller.setConversation((Conversation)this);
        this.cancellers.add(canceller);
    }

    public void acceptInput(@NotNull String input) {
        if (this.currentPrompt != null) {
            if (this.localEchoEnabled) {
                this.context.getForWhom().sendRawMessage(this.userPrefix + input);
            }
            for (ConversationCanceller canceller : this.cancellers) {
                if (!canceller.cancelBasedOnInput(this.context, input)) continue;
                this.abandon(new ConversationAbandonedEvent((Conversation)this, canceller));
                return;
            }
            this.currentPrompt = this.currentPrompt.acceptInput(this.context, input);
            this.outputNextPrompt();
        }
    }

    public void outputNextPrompt() {
        if (this.currentPrompt == null) {
            this.abandon(new ConversationAbandonedEvent((Conversation)this));
        } else {
            String promptText = this.currentPrompt.getPromptText(this.context);
            promptText = this.localizer.localize(promptText, new Replacement[0]);
            promptText = this.messageType.forceColor(promptText);
            this.context.getForWhom().sendRawMessage(this.pluginPrefix + promptText);
            if (!this.currentPrompt.blocksForInput(this.context)) {
                this.currentPrompt = this.currentPrompt.acceptInput(this.context, null);
                this.outputNextPrompt();
            }
        }
    }

    public static class Builder {
        private final Plugin plugin;
        private final Conversable forWhom;
        private final Prompt firstPrompt;
        private Map<Object, Object> initialValues = new HashMap<Object, Object>();
        private String pluginPrefix;
        private String userPrefix = "";
        private MessageType type = MessageType.BLANK;

        public Builder(Plugin plugin, Conversable forWhom, Prompt firstPrompt) {
            this.plugin = plugin;
            this.forWhom = forWhom;
            this.firstPrompt = firstPrompt;
        }

        public Builder withDefaultPluginPrefix() {
            this.pluginPrefix = null;
            return this;
        }

        public Builder withPluginPrefix(String pluginPrefix) {
            this.pluginPrefix = pluginPrefix;
            return this;
        }

        public Builder withDefaultUserPrefix() {
            this.userPrefix = "";
            return this;
        }

        public Builder withUserPrefix(String userPrefix) {
            this.userPrefix = userPrefix;
            return this;
        }

        public Builder ofType(MessageType type) {
            this.type = type;
            return this;
        }

        public Builder withInitalValues(Map<Object, Object> initalValues) {
            this.initialValues = initalValues;
            return this;
        }

        public Builder addIniitialValue(Object key, Object value) {
            this.initialValues.put(key, value);
            return this;
        }

        public EldoConversation build() {
            return new EldoConversation(this.plugin, this.forWhom, this.firstPrompt, this.initialValues, this.pluginPrefix, this.userPrefix, this.type);
        }
    }
}

