/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.conversation;

import LandLord.landlord.eldoutilities.conversation.EldoConversation;
import LandLord.landlord.eldoutilities.messages.MessageType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationRequester
implements ConversationAbandonedListener,
ConversationCanceller {
    private final Plugin plugin;
    private final Map<Player, Long> sessions = new HashMap<Player, Long>();

    private ConversationRequester(Plugin plugin) {
        this.plugin = plugin;
    }

    public static ConversationRequester start(Plugin plugin) {
        return new ConversationRequester(plugin);
    }

    private static Prompt getSimplePromt(final String text, final Predicate<String> validation, final Consumer<String> callback) {
        return new Prompt(){

            @NotNull
            public String getPromptText(@NotNull ConversationContext context) {
                return text;
            }

            public boolean blocksForInput(@NotNull ConversationContext context) {
                return true;
            }

            @Nullable
            public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                if (validation.test(input)) {
                    Bukkit.getScheduler().runTask(context.getPlugin(), () -> callback.accept(input));
                    return null;
                }
                return this;
            }
        };
    }

    public void requestInput(Player player, String text, Predicate<String> validation, int timeout, Consumer<String> callback) {
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        long sessionId = System.currentTimeMillis();
        data.put("id", sessionId);
        this.sessions.put(player, sessionId);
        EldoConversation conversation = EldoConversation.builder(this.plugin, (Conversable)player, ConversationRequester.getSimplePromt(text, validation, callback)).ofType(MessageType.NORMAL).withInitalValues(data).build();
        player.beginConversation((Conversation)conversation);
        conversation.addConversationCanceller(this);
        conversation.addConversationAbandonedListener(this);
        if (timeout > 0) {
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                if (this.sessions.containsKey(player) && this.sessions.get(player) == sessionId) {
                    conversation.abandon(new ConversationAbandonedEvent((Conversation)conversation, (ConversationCanceller)this));
                }
            }, (long)timeout);
        }
    }

    public void conversationAbandoned(@NotNull ConversationAbandonedEvent abandonedEvent) {
        Long aLong;
        Object id = abandonedEvent.getContext().getSessionData((Object)"id");
        if (id != null && (aLong = this.sessions.get(abandonedEvent.getContext().getForWhom())) != null && aLong.equals(id)) {
            this.sessions.remove(abandonedEvent.getContext().getForWhom());
        }
    }

    public void setConversation(@NotNull Conversation conversation) {
    }

    public boolean cancelBasedOnInput(@NotNull ConversationContext context, @NotNull String input) {
        if ("cancel".equalsIgnoreCase(input) && context.getForWhom() instanceof Player) {
            return this.sessions.containsKey(context.getForWhom());
        }
        return false;
    }

    public ConversationRequester clone() {
        return this;
    }
}

