/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.configuration;

import LandLord.landlord.eldoutilities.configuration.ExternalConfigException;
import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.serialization.wrapper.MapEntry;
import LandLord.landlord.eldoutilities.utils.ObjUtil;
import LandLord.landlord.eldoutilities.utils.Parser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class EldoConfig {
    private static EldoConfig instanceConfig = null;
    protected final Plugin plugin;
    private final Path pluginData;
    private final Map<String, FileConfiguration> configs = new HashMap<String, FileConfiguration>();
    private FileConfiguration config;

    public EldoConfig(Plugin plugin) {
        this.plugin = plugin;
        if (instanceConfig == null) {
            instanceConfig = this;
        }
        this.pluginData = plugin.getDataFolder().toPath();
        this.config = plugin.getConfig();
        plugin.saveDefaultConfig();
        ConfigurationSerialization.registerClass(MapEntry.class, (String)"eldoUtilitiesMapEntry");
        if (this.isMainConfig()) {
            this.init();
        }
        this.reload();
        ConfigurationSerialization.unregisterClass((String)"eldoUtilitiesMapEntry");
        this.save();
    }

    public static Level getLogLevel(Plugin plugin) {
        return (Level)((Object)ObjUtil.nonNull(EldoUtilities.getInstanceOwner(plugin.getClass()), instance -> {
            String debug;
            if (!instance.isEnabled()) {
                String config;
                File dataFolder = instance.getDataFolder();
                try {
                    config = Files.readAllLines(Paths.get(dataFolder.getAbsolutePath(), "config.yml")).stream().collect(Collectors.joining("\n"));
                }
                catch (FileNotFoundException e) {
                    return Level.INFO;
                }
                catch (IOException e) {
                    Bukkit.getLogger().log(Level.INFO, "[EldoUtilities] Could not load config file. Using default log level.");
                    return Level.INFO;
                }
                Pattern compile = Pattern.compile("^debug:.?([a-zA-Z].*?)$", 8);
                Matcher matcher = compile.matcher(config);
                debug = matcher.find() ? matcher.group(1) : "INFO";
            } else {
                debug = instance.getConfig().getString("debug", "INFO");
                instance.saveConfig();
            }
            Optional<Boolean> aBoolean = Parser.parseBoolean(debug);
            if (aBoolean.isPresent()) {
                String string = debug = aBoolean.get() != false ? "DEBUG" : "INFO";
                if (instance.isEnabled()) {
                    instance.getConfig().set("debug", (Object)debug);
                    instance.saveConfig();
                }
            }
            return EldoConfig.parseLevel(debug);
        }));
    }

    private static Level parseLevel(String level) {
        if ("OFF".equalsIgnoreCase(level)) {
            return Level.OFF;
        }
        if ("SEVERE".equalsIgnoreCase(level)) {
            return Level.SEVERE;
        }
        if ("WARNING".equalsIgnoreCase(level)) {
            return Level.WARNING;
        }
        if ("INFO".equalsIgnoreCase(level)) {
            return Level.INFO;
        }
        if ("DEBUG".equalsIgnoreCase(level)) {
            return Level.CONFIG;
        }
        if ("CONFIG".equalsIgnoreCase(level)) {
            return Level.CONFIG;
        }
        if ("FINE".equalsIgnoreCase(level)) {
            return Level.FINE;
        }
        if ("FINER".equalsIgnoreCase(level)) {
            return Level.FINER;
        }
        if ("FINEST".equalsIgnoreCase(level)) {
            return Level.FINEST;
        }
        if ("ALL".equalsIgnoreCase(level)) {
            return Level.ALL;
        }
        return Level.INFO;
    }

    public final void save() {
        this.saveConfigs();
        this.writeConfigs();
    }

    protected void saveConfigs() {
    }

    public final void reload() {
        ConfigurationSerialization.registerClass(MapEntry.class, (String)"eldoUtilitiesMapEntry");
        this.readConfigs();
        this.reloadConfigs();
        ConfigurationSerialization.unregisterClass((String)"eldoUtilitiesMapEntry");
    }

    protected void reloadConfigs() {
    }

    private void readConfigs() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.setIfAbsent("debug", "INFO");
        for (Map.Entry<String, FileConfiguration> entry : this.configs.entrySet()) {
            this.loadConfig(Paths.get(entry.getKey(), new String[0]), null, true);
        }
    }

    protected final boolean setIfAbsent(String path, Object value) {
        if (!this.config.isSet(path)) {
            this.config.set(path, value);
            return true;
        }
        return false;
    }

    protected final boolean setIfAbsent(ConfigurationSection section, String path, Object value) {
        if (!section.isSet(path)) {
            section.set(path, value);
            return true;
        }
        return false;
    }

    protected final FileConfiguration loadConfig(String path, @Nullable Consumer<FileConfiguration> defaultCreator, boolean reload) {
        Path configPath = Paths.get(this.pluginData.toString(), path + ".yml");
        return this.loadConfig(configPath, defaultCreator, reload);
    }

    protected final FileConfiguration loadConfig(Path configPath, @Nullable Consumer<FileConfiguration> defaultCreator, boolean reload) {
        this.validateMainConfigEntry();
        File configFile = configPath.toFile();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "could not create directory " + configPath.getParent().toString(), e);
            return null;
        }
        if (!configFile.exists()) {
            try {
                Files.createFile(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not create config.", e);
                return null;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            ObjUtil.nonNull(defaultCreator, d -> d.accept(config));
            try {
                config.save(configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not save default config.");
                return null;
            }
        }
        if (reload) {
            return this.configs.compute(configPath.toString(), (k, v) -> YamlConfiguration.loadConfiguration((File)configFile));
        }
        return this.configs.computeIfAbsent(configPath.toString(), p -> YamlConfiguration.loadConfiguration((File)configFile));
    }

    private void writeConfigs() {
        this.plugin.saveConfig();
        for (Map.Entry<String, FileConfiguration> entry : this.configs.entrySet()) {
            File file = Paths.get(entry.getKey(), new String[0]).toFile();
            if (!file.exists()) {
                try {
                    Files.createFile(file.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not create config.", e);
                    return;
                }
            }
            try {
                entry.getValue().save(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not save config " + file.getAbsolutePath(), e);
            }
        }
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public static EldoConfig getMainConfig() {
        return instanceConfig;
    }

    public final FileConfiguration getConfig() {
        return this.config;
    }

    public final int getVersion() {
        return this.config.getInt("version", -1);
    }

    public final void setVersion(int version, boolean save) {
        this.config.set("version", (Object)version);
        if (save) {
            this.save();
        }
    }

    public Map<String, FileConfiguration> getConfigs() {
        LinkedHashMap<String, FileConfiguration> configs = new LinkedHashMap<String, FileConfiguration>();
        configs.put(Paths.get(this.plugin.getDataFolder().toPath().toString(), "config.yml").toString(), EldoConfig.getMainConfig().getConfig());
        configs.putAll(this.configs);
        return configs;
    }

    protected void init() {
    }

    public boolean isMainConfig() {
        return instanceConfig == this;
    }

    private void validateMainConfigEntry() {
        if (!this.isMainConfig()) {
            throw new ExternalConfigException();
        }
    }
}

