/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class ConfigFileWrapper {
    private final File file;
    @Nullable
    private final Plugin plugin;
    private FileConfiguration fileConfiguration;

    private ConfigFileWrapper(@Nullable Plugin plugin, Path filePath, @Nullable Configuration defaultConfig) {
        this.plugin = plugin;
        this.file = filePath.toFile();
        this.createIfAbsent();
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        if (defaultConfig != null) {
            this.fileConfiguration.addDefaults(defaultConfig);
            this.fileConfiguration.options().copyDefaults(true);
        }
        this.save();
    }

    public static ConfigFileWrapper forFile(Plugin plugin, String filePath) {
        return new ConfigFileWrapper(plugin, ConfigFileWrapper.resolvePath(plugin, filePath), null);
    }

    public static ConfigFileWrapper forFile(Plugin plugin, Path filePath) {
        return new ConfigFileWrapper(plugin, filePath, null);
    }

    public static ConfigFileWrapper forFile(Path filePath) {
        return new ConfigFileWrapper(null, filePath, null);
    }

    public static ConfigFileWrapper forFileWithDefaults(Plugin plugin, String filePath, Map<String, Object> defaultMap) {
        YamlConfiguration defaults = new YamlConfiguration();
        defaultMap.forEach((arg_0, arg_1) -> ((YamlConfiguration)defaults).set(arg_0, arg_1));
        return new ConfigFileWrapper(plugin, ConfigFileWrapper.resolvePath(plugin, filePath), (Configuration)defaults);
    }

    public static ConfigFileWrapper forFileWithDefaults(Plugin plugin, Path filePath, Map<String, Object> defaultMap) {
        YamlConfiguration defaults = new YamlConfiguration();
        defaultMap.forEach((arg_0, arg_1) -> ((YamlConfiguration)defaults).set(arg_0, arg_1));
        return new ConfigFileWrapper(plugin, filePath, (Configuration)defaults);
    }

    public static ConfigFileWrapper forFileWithDefaults(Plugin plugin, String filePath, @Nullable Configuration defaultConfig) {
        return new ConfigFileWrapper(plugin, ConfigFileWrapper.resolvePath(plugin, filePath), defaultConfig);
    }

    public static ConfigFileWrapper forFileWithDefaults(Plugin plugin, Path filePath, @Nullable Configuration defaultConfig) {
        return new ConfigFileWrapper(plugin, filePath, defaultConfig);
    }

    public FileConfiguration get() {
        return this.fileConfiguration;
    }

    public void write(Consumer<FileConfiguration> consumer) {
        consumer.accept(this.fileConfiguration);
        this.save();
    }

    public void save() {
        this.createIfAbsent();
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Could not Save config to " + this.plugin, e);
        }
    }

    public void reload() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void createIfAbsent() {
        if (!Files.exists(this.file.toPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.file.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.log(Level.SEVERE, "Could not create directory at " + this.file.toPath(), e);
            }
            try {
                Files.createFile(this.file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.log(Level.SEVERE, "Could not create config at " + this.file.toPath(), e);
            }
        }
    }

    private void log(Level level, String message, Throwable e) {
        if (this.plugin == null) {
            Bukkit.getLogger().log(level, "[EldoUtilitites] " + message, e);
        } else {
            this.plugin.getLogger().log(level, message, e);
        }
    }

    private static Path resolvePath(Plugin plugin, String filePath) {
        if (plugin == null) {
            return Bukkit.getUpdateFolderFile().toPath().getParent().resolve(filePath);
        }
        return plugin.getDataFolder().toPath().resolve(filePath);
    }
}

