/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.commands.command.util;

import LandLord.landlord.eldoutilities.commands.command.CommandMeta;
import LandLord.landlord.eldoutilities.commands.command.util.Argument;
import LandLord.landlord.eldoutilities.commands.command.util.Arguments;
import LandLord.landlord.eldoutilities.commands.exceptions.CommandException;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.utils.EnumUtil;
import LandLord.landlord.eldoutilities.utils.Parser;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public final class CommandAssertions {
    private CommandAssertions() {
        throw new UnsupportedOperationException("This is a utility class.");
    }

    public static void invalidArguments(CommandMeta meta, String[] args) throws CommandException {
        CommandAssertions.isFalse(args.length < meta.requiredArguments(), "error.invalidArguments", Replacement.create("SYNTAX", meta.name() + " " + meta.argumentString(), new char[0]).addFormatting('6'));
    }

    public static void invalidArguments(CommandMeta meta, Arguments args) throws CommandException {
        CommandAssertions.isFalse(args.size() < meta.requiredArguments(), "error.invalidArguments", Replacement.create("SYNTAX", meta.createCommandCall() + " " + meta.argumentString(), new char[0]).addFormatting('6'));
    }

    public static void invalidArguments(CommandMeta meta, Arguments arguments, Argument ... args) throws CommandException {
        long required = Arrays.stream(args).filter(Argument::isRequired).count();
        String argumentString = Arrays.stream(args).map(Argument::formatted).collect(Collectors.joining(" "));
        CommandAssertions.isFalse((long)arguments.size() < required, "error.invalidArguments", Replacement.create("SYNTAX", meta.createCommandCall() + " " + argumentString, new char[0]).addFormatting('6'));
    }

    public static void invalidArguments(Arguments arguments, Argument ... args) throws CommandException {
        long required = Arrays.stream(args).filter(Argument::isRequired).count();
        String argumentString = Arrays.stream(args).map(Argument::formatted).collect(Collectors.joining(" "));
        CommandAssertions.isFalse((long)arguments.size() < required, "error.invalidArguments", Replacement.create("SYNTAX", argumentString, new char[0]).addFormatting('6'));
    }

    public static void player(CommandSender sender) throws CommandException {
        CommandAssertions.isTrue(sender instanceof Player, "error.onlyPlayer", new Replacement[0]);
    }

    public static void console(CommandSender sender) throws CommandException {
        CommandAssertions.isTrue(sender instanceof ConsoleCommandSender, "error.onlyConsole", new Replacement[0]);
    }

    public static void sender(CommandSender sender, CommandMeta meta) throws CommandException {
        for (Class<? extends CommandSender> clazz : meta.allowedSender()) {
            if (!sender.getClass().isInstance(clazz)) continue;
            return;
        }
        throw CommandException.message("Invalid sender", new Replacement[0]);
    }

    public static void permission(CommandSender sender, CommandMeta meta, boolean silent) throws CommandException {
        CommandAssertions.permission(sender, silent, meta.permissions().toArray(new String[0]));
    }

    public static void permission(CommandSender sender, boolean silent, String ... permissions) throws CommandException {
        if (permissions.length == 0) {
            return;
        }
        for (String permission : permissions) {
            if (!sender.hasPermission(permission)) continue;
            return;
        }
        if (silent) {
            throw CommandException.silent();
        }
        throw CommandException.message("error.permission", Replacement.create("permission", String.join((CharSequence)", ", permissions), new char[0]));
    }

    public static void range(double value, double min, double max) throws CommandException {
        CommandAssertions.isTrue(value <= max && value >= min, "error.invalidRange", Replacement.create("MIN", min, new char[0]).addFormatting('6'), Replacement.create("MAX", max, new char[0]).addFormatting('6'));
    }

    public static void range(int value, int min, int max) throws CommandException {
        CommandAssertions.isTrue(value <= max && value >= min, "error.invalidRange", Replacement.create("MIN", min, new char[0]).addFormatting('6'), Replacement.create("MAX", max, new char[0]).addFormatting('6'));
    }

    public static void min(int value, int min) throws CommandException {
        CommandAssertions.isTrue(value >= min, "error.tooLow", Replacement.create("MIN", min, new char[0]).addFormatting('6'));
    }

    public static void min(double value, double min) throws CommandException {
        CommandAssertions.isTrue(value >= min, "error.tooLow", Replacement.create("MIN", min, new char[0]).addFormatting('6'));
    }

    public static void max(int value, int max) throws CommandException {
        CommandAssertions.isTrue(value <= max, "error.tooLarge", Replacement.create("MAX", max, new char[0]).addFormatting('6'));
    }

    public static void max(double value, double max) throws CommandException {
        CommandAssertions.isTrue(value <= max, "error.tooLarge", Replacement.create("MAX", max, new char[0]).addFormatting('6'));
    }

    public static <T extends Enum<T>> void enumValue(String value, Class<T> clazz) throws CommandException {
        CommandAssertions.isTrue(EnumUtil.parse(value, clazz).isPresent(), "error.invalidEnumValue", Replacement.create("VALUES", Replacement.create("VALUES", EnumUtil.enumValues(clazz), new char[0]).addFormatting('6'), new char[0]));
    }

    public static void invalidNumber() throws CommandException {
        throw CommandException.message("error.invalidNumber", new Replacement[0]);
    }

    public static void isInteger(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseInt(value).isPresent(), "error.invalidNumber", new Replacement[0]);
    }

    public static void isLong(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseLong(value).isPresent(), "error.invalidNumber", new Replacement[0]);
    }

    public static void isDouble(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseDouble(value).isPresent(), "error.invalidNumber", new Replacement[0]);
    }

    public static void isBoolean(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseBoolean(value).isPresent(), "error.invalidBoolen", new Replacement[0]);
    }

    public static void isBoolean(String value, String isTrue, String isFalse) throws CommandException {
        CommandAssertions.isTrue(Parser.parseBoolean(value, isTrue, isFalse).isPresent(), "error.invalidBoolen", new Replacement[0]);
    }

    public static void invalidLength(String input, int max) throws CommandException {
        CommandAssertions.isTrue(input.length() < max, "error.invalidLength", Replacement.create("max", max, new char[0]));
    }

    public static void missingArgument(String[] args, int index) throws CommandException {
        CommandAssertions.isTrue(args.length > index, "error.missingArgument", Replacement.create("index", index, new char[0]));
    }

    public static void isFalse(boolean eval, String message, Replacement ... replacements) throws CommandException {
        CommandAssertions.isTrue(!eval, message, replacements);
    }

    public static void isTrue(boolean eval, String message, Replacement ... replacements) throws CommandException {
        if (eval) {
            return;
        }
        throw CommandException.message(message, replacements);
    }

    public static void evalAssertSilent(boolean eval) throws CommandException {
        if (!eval) {
            return;
        }
        throw CommandException.silent();
    }

    public static void allowedSender(CommandMeta meta, CommandSender sender) throws CommandException {
        if (meta.allowedSender().isEmpty()) {
            return;
        }
        if (meta.allowedSender().contains(sender.getClass())) {
            return;
        }
        throw CommandException.message("error.invalidSender", new Replacement[0]);
    }
}

