/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.commands.command.util;

import LandLord.landlord.eldoutilities.commands.command.util.CommandAssertions;
import LandLord.landlord.eldoutilities.commands.exceptions.CommandException;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.utils.ArgumentUtils;
import LandLord.landlord.eldoutilities.utils.EnumUtil;
import LandLord.landlord.eldoutilities.utils.FlagContainer;
import LandLord.landlord.eldoutilities.utils.Parser;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Arguments
implements Iterable<String> {
    private final FlagContainer flags;
    Plugin plugin;
    private String[] args;

    private Arguments(Plugin plugin, String[] args, FlagContainer flags) {
        this.args = args;
        this.flags = flags;
    }

    public static Arguments create(Plugin plugin, String[] args) {
        FlagContainer flags = FlagContainer.of(args);
        return new Arguments(plugin, args, flags);
    }

    public void assertLength(int index) throws CommandException {
        CommandAssertions.missingArgument(this.args, index);
    }

    public boolean hasArg(int index) {
        return this.args.length > index;
    }

    public int size() {
        return this.args.length;
    }

    public boolean isEmpty() {
        return this.args.length == 0;
    }

    public void parseQuoted() {
        this.args = ArgumentUtils.parseQuotedArgs(this.args);
    }

    public void splitArgs() {
        this.args = Arrays.stream(this.args).map(arg -> arg.contains(" ") ? String.format("\"%s\"", arg) : arg).collect(Collectors.joining(" ")).split(" ");
    }

    @NotNull
    public String asString(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            return this.args[this.args.length + index];
        }
        return this.args[index];
    }

    @NotNull
    public String asString(int index, String def) {
        if (this.hasArg(index)) {
            return this.asString(index);
        }
        return def;
    }

    public int asInt(int index) throws CommandException, IndexOutOfBoundsException {
        return Parser.parseInt(this.asString(index)).orElseThrow(() -> CommandException.message("error.invalidNumber", new Replacement[0]));
    }

    public int asInt(int index, int def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asInt(index);
        }
        return def;
    }

    public long asLong(int index) throws CommandException, IndexOutOfBoundsException {
        return Parser.parseLong(this.asString(index)).orElseThrow(() -> CommandException.message("error.invalidNumber", new Replacement[0]));
    }

    public long asLong(int index, long def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asLong(index);
        }
        return def;
    }

    public double asDouble(int index) throws CommandException, IndexOutOfBoundsException {
        return Parser.parseDouble(this.asString(index)).orElseThrow(() -> CommandException.message("error.invalidNumber", new Replacement[0]));
    }

    public double asDouble(int index, double def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asDouble(index);
        }
        return def;
    }

    public boolean asBoolean(int index) throws CommandException, IndexOutOfBoundsException {
        return this.asBoolean(index, "true", "false");
    }

    public boolean asBoolean(int index, boolean def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asBoolean(index);
        }
        return def;
    }

    public boolean asBoolean(int index, String aTrue, String aFalse, boolean def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asBoolean(index, aTrue, aFalse);
        }
        return def;
    }

    public boolean asBoolean(int index, String aTrue, String aFalse) throws CommandException, IndexOutOfBoundsException {
        return Parser.parseBoolean(this.asString(index), aTrue, aFalse).orElseThrow(() -> CommandException.message("error.invalidBoolean", Replacement.create("true", aTrue, new char[0]), Replacement.create("false", aFalse, new char[0])));
    }

    @NotNull
    public Material asMaterial(int index) throws CommandException, IndexOutOfBoundsException {
        return this.asMaterial(index, false);
    }

    @NotNull
    public Material asMaterial(int index, Material def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asMaterial(index);
        }
        return def;
    }

    @NotNull
    public Material asMaterial(int index, boolean stripStrings) throws CommandException, IndexOutOfBoundsException {
        return EnumUtil.parse(this.asString(index), Material.class, stripStrings).orElseThrow(() -> CommandException.message("error.invalidMaterial", new Replacement[0]));
    }

    @NotNull
    public Material asMaterial(int index, boolean stripStrings, Material def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asMaterial(index, stripStrings);
        }
        return def;
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz) throws CommandException, IndexOutOfBoundsException {
        return this.asEnum(index, clazz, false);
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, T def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asEnum(index, clazz);
        }
        return def;
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, boolean stripStrings) throws CommandException, IndexOutOfBoundsException {
        return (T)((Enum)EnumUtil.parse(this.asString(index), clazz, stripStrings).orElseThrow(() -> CommandException.message("error.invalidEnumValue", Replacement.create("VALUES", EnumUtil.enumValues(clazz), new char[0]).addFormatting('6'))));
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, boolean stripStrings, T def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asEnum(index, clazz, stripStrings);
        }
        return def;
    }

    @NotNull
    public Player asPlayer(int index) throws CommandException, IndexOutOfBoundsException {
        Player player = this.plugin.getServer().getPlayer(this.asString(index));
        if (player == null) {
            throw CommandException.message("error.notOnline", new Replacement[0]);
        }
        return player;
    }

    @NotNull
    public Player asPlayer(int index, Player def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asPlayer(index);
        }
        return def;
    }

    @NotNull
    public OfflinePlayer asOfflinePlayer(int index) throws CommandException, IndexOutOfBoundsException {
        String name = this.asString(index);
        for (OfflinePlayer player : this.plugin.getServer().getOfflinePlayers()) {
            if (!name.equalsIgnoreCase(player.getName())) continue;
            return player;
        }
        throw CommandException.message("error.unkownPlayer", new Replacement[0]);
    }

    @NotNull
    public OfflinePlayer asOfflinePlayer(int index, OfflinePlayer def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asOfflinePlayer(index);
        }
        return def;
    }

    @NotNull
    public World asWorld(int index) throws CommandException, IndexOutOfBoundsException {
        String name = this.asString(index);
        World world = this.plugin.getServer().getWorld(name);
        if (world == null) {
            throw CommandException.message("error.unkownWorld", new Replacement[0]);
        }
        return world;
    }

    @NotNull
    public World asWorld(int index, World def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asWorld(index);
        }
        return def;
    }

    public List<String> args(int from) {
        return ArgumentUtils.getRangeAsList(this.args, from);
    }

    public String join() {
        return this.join(" ");
    }

    public String join(int from) {
        return this.join(" ", from);
    }

    public String join(int from, int to) {
        return this.join(" ", from, to);
    }

    public String join(String delimiter) {
        return String.join((CharSequence)delimiter, this.args);
    }

    public String join(String delimiter, int from) {
        return ArgumentUtils.getMessage(this.args, from);
    }

    public String join(String delimiter, int from, int to) {
        return ArgumentUtils.getMessage(this.args, from, to);
    }

    public List<String> args() {
        return Arrays.asList(this.args);
    }

    public String[] asArray() {
        return (String[])this.args.clone();
    }

    public List<String> args(int from, int to) {
        return ArgumentUtils.getRangeAsList(this.args, from, to);
    }

    private <T> Optional<T> parseArg(int index, Function<String, Optional<T>> map) {
        String value = this.asString(index);
        return map.apply(value);
    }

    public Arguments subArguments() {
        return Arguments.create(this.plugin, ArgumentUtils.getRangeAsList(this.args, 1).toArray(new String[0]));
    }

    public boolean hasFlag(@NotNull String flag) {
        return this.flags.has(flag);
    }

    public boolean hasFlagValue(String flag) {
        return this.flags.hasValue(flag);
    }

    public <T> T getFlag(@NotNull String flag, Function<@Nullable String, T> map) {
        return this.flags.get(flag, map);
    }

    @Nullable
    public String getFlag(String flag) {
        return this.flags.get(flag);
    }

    public Optional<String> getFlagValueIfPresent(String flag) {
        return this.flags.getIfPresent(flag);
    }

    public <T> Optional<T> getFlagValueIfPresent(@NotNull String flag, Function<String, T> map) {
        return this.flags.getIfPresent(flag, map);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.args().iterator();
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.args().spliterator();
    }

    public Stream<String> stream() {
        return this.args().stream();
    }

    public Stream<String> parallelStream() {
        return this.args().parallelStream();
    }

    public String toString() {
        return "Arguments{flags=" + this.flags + ", plugin=" + this.plugin.getName() + ", args=" + Arrays.toString(this.args) + '}';
    }
}

