/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.commands.command;

import LandLord.landlord.eldoutilities.commands.command.AdvancedCommand;
import LandLord.landlord.eldoutilities.commands.command.util.Arguments;
import LandLord.landlord.eldoutilities.commands.exceptions.CommandException;
import LandLord.landlord.eldoutilities.localization.DummyLocalizer;
import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.messages.MessageSender;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedCommandAdapter
implements TabExecutor {
    private final Plugin plugin;
    private final AdvancedCommand advancedCommand;
    private ILocalizer localizer;
    private MessageSender messageSender;

    public static AdvancedCommandAdapter wrap(Plugin plugin, AdvancedCommand advancedCommand) {
        return new AdvancedCommandAdapter(plugin, advancedCommand);
    }

    private AdvancedCommandAdapter(Plugin plugin, AdvancedCommand advancedCommand) {
        this.plugin = plugin;
        this.advancedCommand = advancedCommand;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        try {
            this.executeCommand(sender, label, args);
        }
        catch (CommandException e) {
            this.messageSender().sendLocalizedError(sender, e.getMessage(), e.replacements());
            this.plugin.getLogger().log(Level.CONFIG, "Command exception occured.", e);
        }
        return true;
    }

    private void executeCommand(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) throws CommandException {
        Arguments arguments = Arguments.create(this.plugin, args);
        this.advancedCommand.commandRoute(sender, label, arguments);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List<String> strings;
        Arguments arguments = Arguments.create(this.plugin, args);
        try {
            strings = this.advancedCommand.tabCompleteRoute(sender, label, arguments);
        }
        catch (CommandException e) {
            strings = Collections.singletonList(this.localizer().localize(e.getMessage(), e.replacements()));
            this.plugin.getLogger().log(Level.CONFIG, "Command exception occured.", e);
        }
        return strings;
    }

    protected final ILocalizer localizer() {
        if (this.localizer == null || this.localizer instanceof DummyLocalizer) {
            this.localizer = ILocalizer.getPluginLocalizer(this.plugin);
        }
        return this.localizer;
    }

    protected final MessageSender messageSender() {
        if (this.messageSender == null || this.messageSender.isDefault()) {
            this.messageSender = MessageSender.getPluginMessageSender(this.plugin);
        }
        return this.messageSender;
    }
}

