/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.commands.command;

import LandLord.landlord.eldoutilities.commands.command.CommandMeta;
import LandLord.landlord.eldoutilities.commands.command.CommandRoute;
import LandLord.landlord.eldoutilities.commands.command.util.Arguments;
import LandLord.landlord.eldoutilities.commands.command.util.CommandAssertions;
import LandLord.landlord.eldoutilities.commands.exceptions.CommandException;
import LandLord.landlord.eldoutilities.commands.executor.IConsoleTabExecutor;
import LandLord.landlord.eldoutilities.commands.executor.IPlayerTabExecutor;
import LandLord.landlord.eldoutilities.commands.executor.ITabExecutor;
import LandLord.landlord.eldoutilities.localization.DummyLocalizer;
import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.messages.MessageSender;
import LandLord.landlord.eldoutilities.simplecommands.TabCompleteUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedCommand
implements CommandRoute {
    private final Plugin plugin;
    private CommandMeta meta;
    private ILocalizer localizer;
    private MessageSender messageSender;

    public AdvancedCommand(Plugin plugin, CommandMeta meta) {
        this.plugin = plugin;
        this.meta = meta;
        this.linkMeta();
    }

    public AdvancedCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    private void linkMeta() {
        for (AdvancedCommand cmd : this.meta.subCommands().values()) {
            cmd.meta().parent(this);
        }
    }

    @Override
    public void commandRoute(CommandSender sender, String label, Arguments args) throws CommandException {
        CommandAssertions.permission(sender, this.meta(), false);
        if (this instanceof IConsoleTabExecutor) {
            CommandAssertions.console(sender);
        }
        if (this instanceof IPlayerTabExecutor) {
            CommandAssertions.player(sender);
        }
        if (this instanceof IPlayerTabExecutor && sender instanceof Player) {
            CommandAssertions.invalidArguments(this.meta(), args);
            ((IPlayerTabExecutor)((Object)this)).onCommand((Player)sender, label, args);
            return;
        }
        if (this instanceof IConsoleTabExecutor && sender instanceof ConsoleCommandSender) {
            CommandAssertions.invalidArguments(this.meta(), args);
            ((IConsoleTabExecutor)((Object)this)).onCommand((ConsoleCommandSender)sender, label, args);
            return;
        }
        if (this instanceof ITabExecutor) {
            CommandAssertions.invalidArguments(this.meta(), args);
            CommandAssertions.allowedSender(this.meta, sender);
            ((ITabExecutor)((Object)this)).onCommand(sender, label, args);
            return;
        }
        if (args.isEmpty()) {
            if (this.meta.defaultCommand() != null) {
                this.meta.defaultCommand().commandRoute(sender, label, args);
                return;
            }
            throw CommandException.message("error.invalidCommand", new Replacement[0]);
        }
        if (this.meta.subCommands().isEmpty()) {
            throw CommandException.message("Unhandled end of command route. The command needs to implement a executor or subcommands", new Replacement[0]);
        }
        Arguments newArgs = args.subArguments();
        Optional<AdvancedCommand> command = this.getCommand(args.asString(0));
        if (command.isPresent()) {
            command.get().commandRoute(sender, args.asString(0), newArgs);
            return;
        }
        throw CommandException.message("error.invalidCommand", new Replacement[0]);
    }

    @Override
    @Nullable
    public List<String> tabCompleteRoute(CommandSender sender, String label, Arguments args) throws CommandException {
        if (!this.meta().permissions().isEmpty()) {
            boolean access = false;
            for (String permission : this.meta().permissions()) {
                if (!sender.hasPermission(permission)) continue;
                access = true;
                break;
            }
            if (!access) {
                String permissions = String.join((CharSequence)", ", this.meta().permissions());
                return Collections.singletonList(this.localizer.localize("error.permission", Replacement.create("PERMISSION", permissions, new char[0])));
            }
        }
        if (this instanceof IPlayerTabExecutor && sender instanceof Player) {
            return ((IPlayerTabExecutor)((Object)this)).onTabComplete((Player)sender, label, args);
        }
        if (this instanceof IConsoleTabExecutor && sender instanceof ConsoleCommandSender) {
            return ((IConsoleTabExecutor)((Object)this)).onTabComplete((ConsoleCommandSender)sender, label, args);
        }
        if (this instanceof ITabExecutor) {
            return ((ITabExecutor)((Object)this)).onTabComplete(sender, label, args);
        }
        if (args.size() == 1) {
            return TabCompleteUtil.complete(args.asString(0), this.meta.registeredCommands());
        }
        Optional<AdvancedCommand> command = this.getCommand(args.asString(0));
        if (!command.isPresent()) {
            return Collections.singletonList(this.localizer().getMessage("error.invalidCommand", new Replacement[0]));
        }
        return command.get().tabCompleteRoute(sender, args.asString(0), args.subArguments());
    }

    private Optional<AdvancedCommand> getCommand(String command) {
        for (AdvancedCommand entry : this.meta.subCommands().values()) {
            if (!entry.meta().isCommand(command)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    protected final ILocalizer localizer() {
        if (this.localizer == null || this.localizer instanceof DummyLocalizer) {
            this.localizer = ILocalizer.getPluginLocalizer(this.plugin);
        }
        return this.localizer;
    }

    protected final MessageSender messageSender() {
        if (this.messageSender == null || this.messageSender.isDefault()) {
            this.messageSender = MessageSender.getPluginMessageSender(this.plugin);
        }
        return this.messageSender;
    }

    protected final Player getPlayerFromSender(CommandSender sender) {
        return sender instanceof Player ? (Player)sender : null;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public final CommandMeta meta() {
        Objects.requireNonNull(this.meta);
        return this.meta;
    }

    protected final void meta(CommandMeta meta) {
        if (this.meta != null) {
            throw new IllegalStateException("Meta is already assigned");
        }
        this.meta = meta;
        this.linkMeta();
    }
}

