/*
 * Decompiled with CFR 0.152.
 */
package de.snuboyt.kffa.listener;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerListeners
implements Listener {
    @EventHandler
    public void onChange(FoodLevelChangeEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVoidEnter(PlayerMoveEvent e) {
        if (e.getTo().getBlockY() < -1) {
            e.getPlayer().setHealth(0.0);
            e.getPlayer().spigot().respawn();
        }
    }

    @EventHandler
    public void onSword123(EntityDamageByEntityEvent e) {
        Player damager = (Player)e.getDamager();
        Player target = (Player)e.getEntity();
        if (e.getDamager() instanceof Player && target instanceof Player) {
            if (damager.getItemInHand().getType() == Material.STICK) {
                e.setDamage(0.0);
            } else if (damager.getItemInHand().getType() == Material.ENDER_CHEST) {
                e.setDamage(0.0);
            } else if (damager.getItemInHand().getType() == Material.FISHING_ROD) {
                e.setDamage(0.0);
            } else if (damager.getItemInHand().getType() == Material.SANDSTONE) {
                e.setDamage(0.0);
            } else if (damager.getItemInHand().getType() == Material.ENDER_PEARL) {
                e.setDamage(0.0);
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }
}

