/*
 * Decompiled with CFR 0.152.
 */
package listener;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import talent.Main;

public class ChairListener
implements Listener {
    Main plugin;
    public Map<Player, Location> playerLocation = new HashMap<Player, Location>();
    public Map<Player, Entity> chairList = new HashMap<Player, Entity>();
    public Map<Player, Location> chairLocation = new HashMap<Player, Location>();
    Logger log = Logger.getLogger("Minecraft");

    public ChairListener(Main instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getClickedBlock() != null) {
            Block block = event.getClickedBlock();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && !player.isInsideVehicle() && player.getItemInHand().getType() == Material.AIR) {
                String blockMaterial = block.getType().name();
                for (String chairBlock : this.plugin.getConfig().getStringList("Chairs")) {
                    if (!blockMaterial.equalsIgnoreCase(chairBlock)) continue;
                    if (!this.plugin.getConfig().getBoolean("UpsideDown") && block.getData() > 3) {
                        return;
                    }
                    int range = this.plugin.getConfig().getInt("Range");
                    if (range > 0 && player.getLocation().distance(block.getLocation()) - 1.0 > (double)range) {
                        return;
                    }
                    World world = player.getWorld();
                    this.playerLocation.put(player, player.getLocation());
                    Entity chair = world.spawnEntity(player.getLocation(), EntityType.ARROW);
                    this.chairList.put(player, chair);
                    chair.teleport(block.getLocation().add(0.5, 0.2, 0.5));
                    this.chairLocation.put(player, chair.getLocation());
                    chair.setPassenger((Entity)player);
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.playerLocation.containsKey(event.getPlayer())) {
            if (event.getPlayer().isSneaking()) {
                Player player;
                final Player sit_player = player = event.getPlayer();
                final Location stand_location = this.playerLocation.get(player);
                Entity sit_chair = this.chairList.get(player);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        sit_player.teleport(stand_location);
                        sit_player.setSneaking(false);
                    }
                }, 1L);
                event.setCancelled(true);
                this.playerLocation.remove(player);
                sit_chair.remove();
                this.chairList.remove(player);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player;
        if (this.playerLocation.containsKey(event.getPlayer()) && (player = event.getPlayer()).getLocation() != this.playerLocation.get(player) && !player.isInsideVehicle()) {
            World world = player.getWorld();
            if (this.chairLocation.containsKey(player)) {
                Entity chair = world.spawnEntity(this.chairLocation.get(player), EntityType.ARROW);
                chair.setPassenger((Entity)player);
            }
        }
    }
}

