/*
 * Decompiled with CFR 0.152.
 */
package io.github.KyokoSenpai.APG;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.KyokoSenpai.APG.Main;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.InventoryHolder;

public class PearlEvent
implements Listener {
    private final ImmutableSet<Material> blockedPearlTypes = Sets.immutableEnumSet((Enum)Material.THIN_GLASS, (Enum[])new Material[]{Material.IRON_FENCE, Material.FENCE, Material.NETHER_FENCE, Material.FENCE_GATE, Material.ACACIA_STAIRS, Material.BIRCH_WOOD_STAIRS, Material.BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.DARK_OAK_STAIRS, Material.JUNGLE_WOOD_STAIRS, Material.NETHER_BRICK_STAIRS, Material.QUARTZ_STAIRS, Material.SANDSTONE_STAIRS, Material.SMOOTH_STAIRS, Material.SPRUCE_WOOD_STAIRS, Material.WOOD_STAIRS});
    private final Main plugin;

    public PearlEvent(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.hasItem() && event.getItem().getType() == Material.ENDER_PEARL && (block = event.getClickedBlock()).getType().isSolid() && !(block.getState() instanceof InventoryHolder)) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            player.setItemInHand(event.getItem());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPearlClip(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            Location to = event.getTo();
            if (this.blockedPearlTypes.contains((Object)to.getBlock().getType())) {
                Player player = event.getPlayer();
                player.sendMessage(Main.c(Main.cfg.getString("PearlGlitch.MSG")));
                event.setCancelled(true);
                return;
            }
            to.setX((double)to.getBlockX() + 0.5);
            to.setZ((double)to.getBlockZ() + 0.5);
            event.setTo(to);
        }
    }
}

