/*
 * Decompiled with CFR 0.152.
 */
package dev.nikho.lockker.utils;

import dev.nikho.lockker.Lockker;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtils {
    public static ItemStack getItems(String name, Player p, FileConfiguration file) {
        ItemStack it;
        try {
            it = new ItemStack(ItemUtils.getId(name, p, file), ItemUtils.getCount(name, p, file), (short)((byte)ItemUtils.getData(name, p, file)));
            ItemMeta itM = it.getItemMeta();
            itM.setDisplayName(Lockker.translate(false, ItemUtils.getName(name, p, file), null, p));
            itM.setLore(ItemUtils.getLore(name, p, file));
            it.setItemMeta(itM);
        }
        catch (Exception e) {
            it = null;
        }
        return it;
    }

    public static int getId(String name, Player p, FileConfiguration file) {
        int nb = 0;
        try {
            nb = file.getInt(String.valueOf(name) + ".id");
        }
        catch (NullPointerException e) {
            nb = -1;
            Bukkit.broadcastMessage((String)Lockker.translate(true, "errorWithItem", Lockker.getF().getConfig(), p));
        }
        return nb;
    }

    public static int getData(String name, Player p, FileConfiguration file) {
        int nb = 0;
        try {
            nb = file.getInt(String.valueOf(name) + ".data");
        }
        catch (NullPointerException e) {
            nb = -1;
            Bukkit.broadcastMessage((String)Lockker.translate(true, "errorWithItem", Lockker.getF().getConfig(), p));
        }
        return nb;
    }

    public static int getCount(String name, Player p, FileConfiguration file) {
        int nb = 0;
        try {
            nb = file.getInt(String.valueOf(name) + ".count");
        }
        catch (NullPointerException e) {
            nb = -1;
            Bukkit.broadcastMessage((String)Lockker.translate(true, "errorWithItem", Lockker.getF().getConfig(), p));
        }
        return nb;
    }

    public static String getName(String name, Player p, FileConfiguration file) {
        String nb = null;
        try {
            nb = file.getString(String.valueOf(name) + ".name");
        }
        catch (NullPointerException e) {
            nb = null;
            Bukkit.broadcastMessage((String)Lockker.translate(true, "errorWithItem", Lockker.getF().getConfig(), p));
        }
        return nb;
    }

    public static ArrayList<String> getLore(String name, Player p, FileConfiguration file) {
        ArrayList<String> nb = new ArrayList<String>();
        try {
            for (String s : file.getStringList(String.valueOf(name) + ".lore")) {
                nb.add(Lockker.translate(false, s, null, p));
            }
        }
        catch (NullPointerException e) {
            nb = null;
            Bukkit.broadcastMessage((String)Lockker.translate(true, "errorWithItem", Lockker.getF().getConfig(), p));
        }
        return nb;
    }
}

