/*
 * Decompiled with CFR 0.152.
 */
package dev.nikho.lockker.utils;

import dev.nikho.lockker.Lockker;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class DataUtils {
    public static void setChestLock(String key, Location loc, String serialkey) {
        try {
            DataUtils.setChestX(key, loc.getBlockX());
            DataUtils.setChestY(key, loc.getBlockY());
            DataUtils.setChestZ(key, loc.getBlockZ());
            DataUtils.setChestEnable(key, true);
            DataUtils.setChestWorld(key, loc.getWorld().getName());
            DataUtils.setChestKey(key, serialkey);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.WARNING, "Error with lock");
            Bukkit.getLogger().log(Level.WARNING, e.getMessage());
        }
    }

    public static void removeChestLock(Location loc) {
        for (String key : Lockker.getF().getData().getConfigurationSection("").getKeys(false)) {
            if (DataUtils.getChestX(key) != loc.getBlockX() || DataUtils.getChestY(key) != loc.getBlockY() || DataUtils.getChestZ(key) != loc.getBlockZ()) continue;
            Lockker.getF().getData().set(key, null);
            Lockker.getF().loadData();
        }
    }

    public static boolean isChestLock(Location loc) {
        boolean ischest = false;
        for (String key : Lockker.getF().getData().getConfigurationSection("").getKeys(false)) {
            if (DataUtils.getChestX(key) != loc.getBlockX() || DataUtils.getChestY(key) != loc.getBlockY() || DataUtils.getChestZ(key) != loc.getBlockZ()) continue;
            ischest = true;
        }
        return ischest;
    }

    public static int getChestX(String key) {
        return Lockker.getF().getData().getInt(String.valueOf(key) + ".x");
    }

    public static void setChestX(String key, int x) {
        Lockker.getF().getData().set(String.valueOf(key) + ".x", (Object)x);
        Lockker.getF().loadData();
    }

    public static int getChestY(String key) {
        return Lockker.getF().getData().getInt(String.valueOf(key) + ".y");
    }

    public static void setChestY(String key, int y) {
        Lockker.getF().getData().set(String.valueOf(key) + ".y", (Object)y);
        Lockker.getF().loadData();
    }

    public static int getChestZ(String key) {
        return Lockker.getF().getData().getInt(String.valueOf(key) + ".z");
    }

    public static void setChestZ(String key, int z) {
        Lockker.getF().getData().set(String.valueOf(key) + ".z", (Object)z);
        Lockker.getF().loadData();
    }

    public static String getChestWorld(String key) {
        return Lockker.getF().getData().getString(String.valueOf(key) + ".world");
    }

    public static void setChestWorld(String key, String name) {
        Lockker.getF().getData().set(String.valueOf(key) + ".world", (Object)name);
        Lockker.getF().loadData();
    }

    public static boolean getChestEnable(String key) {
        return Lockker.getF().getData().getBoolean(String.valueOf(key) + ".enable");
    }

    public static void setChestEnable(String key, boolean enable) {
        Lockker.getF().getData().set(String.valueOf(key) + ".enable", (Object)enable);
        Lockker.getF().loadData();
    }

    public static String getChestKey(String key) {
        return Lockker.getF().getData().getString(String.valueOf(key) + ".key");
    }

    public static void setChestKey(String key, String skey) {
        Lockker.getF().getData().set(String.valueOf(key) + ".key", (Object)skey);
        Lockker.getF().loadData();
    }

    public static boolean isChestKey(Location loc, String key) {
        boolean ischest = false;
        for (String k : Lockker.getF().getData().getConfigurationSection("").getKeys(false)) {
            if (DataUtils.getChestX(k) != loc.getBlockX() || DataUtils.getChestY(k) != loc.getBlockY() || DataUtils.getChestZ(k) != loc.getBlockZ() || !loc.getWorld().getName().equalsIgnoreCase(DataUtils.getChestWorld(k)) || !key.contains(DataUtils.getChestKey(k))) continue;
            ischest = true;
        }
        return ischest;
    }

    public static Location getDoubleChest(Block b) {
        Location loc = b.getLocation();
        Location rloc = null;
        Material m = loc.getBlock().getType();
        if (loc.clone().add(1.0, 0.0, 0.0).getBlock().getType() == m) {
            rloc = loc.clone().add(1.0, 0.0, 0.0);
        }
        if (loc.clone().add(0.0, 0.0, 1.0).getBlock().getType() == m) {
            rloc = loc.clone().add(0.0, 0.0, 1.0);
        }
        if (loc.clone().add(-1.0, 0.0, 0.0).getBlock().getType() == m) {
            rloc = loc.clone().add(-1.0, 0.0, 0.0);
        }
        if (loc.clone().add(0.0, 0.0, -1.0).getBlock().getType() == m) {
            rloc = loc.clone().add(0.0, 0.0, -1.0);
        }
        return rloc;
    }

    public static boolean isDoubleChest(Block b, String key) {
        boolean isdbc = false;
        Location loc = b.getLocation();
        Material m = loc.getBlock().getType();
        if (loc.clone().add(1.0, 0.0, 0.0).getBlock().getType() == m) {
            isdbc = true;
            DataUtils.setChestLock(UUID.randomUUID().toString(), loc.clone().add(1.0, 0.0, 0.0), key);
        }
        if (loc.clone().add(0.0, 0.0, 1.0).getBlock().getType() == m) {
            DataUtils.setChestLock(UUID.randomUUID().toString(), loc.clone().add(0.0, 0.0, 1.0), key);
            isdbc = true;
        }
        if (loc.clone().add(-1.0, 0.0, 0.0).getBlock().getType() == m) {
            DataUtils.setChestLock(UUID.randomUUID().toString(), loc.clone().add(-1.0, 0.0, 0.0), key);
            isdbc = true;
        }
        if (loc.clone().add(0.0, 0.0, -1.0).getBlock().getType() == m) {
            DataUtils.setChestLock(UUID.randomUUID().toString(), loc.clone().add(0.0, 0.0, -1.0), key);
            isdbc = true;
        }
        return isdbc;
    }

    public static void isDoubleChestRemove(Block b) {
        Location loc = b.getLocation();
        if (DataUtils.getDoubleChest(b) != null) {
            Location dbloc = DataUtils.getDoubleChest(b);
            for (String key : Lockker.getF().getData().getConfigurationSection("").getKeys(false)) {
                if (Lockker.getF().getData().getInt(String.valueOf(key) + ".x") != dbloc.getBlockX() || Lockker.getF().getData().getInt(String.valueOf(key) + ".y") != dbloc.getBlockY() || Lockker.getF().getData().getInt(String.valueOf(key) + ".z") != dbloc.getBlockZ()) continue;
                Lockker.getF().getData().set(key, null);
                Lockker.getF().loadData();
            }
        }
    }
}

