/*
 * Decompiled with CFR 0.152.
 */
package dev.nikho.lockker.gui;

import dev.nikho.lockker.Lockker;
import dev.nikho.lockker.utils.ItemUtils;
import dev.nikho.lockker.utils.PermUtils;
import dev.nikho.lockker.utils.SoundUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MainGui
implements Listener {
    private ArrayList<Player> playerlist = new ArrayList();
    private Inventory mainGui;
    private ItemStack nocase;
    private ItemStack createKey;

    public void open(Player p) {
        this.loadInv(p);
        this.loadItems(p);
        p.openInventory(this.mainGui);
    }

    public void loadInv(Player p) {
        this.mainGui = Bukkit.createInventory(null, (int)27, (String)Lockker.translate(true, "gui.mainGui.title", Lockker.getF().getConfig(), p));
    }

    public void loadItems(Player p) {
        this.createKey = ItemUtils.getItems("gui.mainGui.items.createKey", p, Lockker.getF().getConfig());
        this.nocase = new ItemStack(160, 1, 5);
        int i = 0;
        while (i < 27) {
            if (i != 13) {
                this.mainGui.setItem(i, this.nocase);
            } else {
                this.mainGui.setItem(i, this.createKey);
            }
            ++i;
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        ItemStack clicked = e.getCurrentItem();
        Inventory inv = e.getInventory();
        this.loadInv(p);
        if (inv.getName() == this.mainGui.getName() && clicked != null && clicked.getType() != Material.AIR) {
            this.loadItems(p);
            if (clicked.equals((Object)this.createKey)) {
                if (PermUtils.hasPerm(p, PermUtils.lockker_gui_createkey)) {
                    p.closeInventory();
                    this.playerlist.add(p);
                    p.sendMessage(Lockker.translate(true, "writeKey", Lockker.getF().getConfig(), p));
                } else {
                    p.closeInventory();
                    p.sendMessage(Lockker.translate(true, "noPermission", Lockker.getF().getConfig(), p));
                }
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        String msg = e.getMessage();
        if (this.playerlist.contains(p)) {
            if (msg.contentEquals(Lockker.getF().getConfig().getString("cancel"))) {
                p.sendMessage(Lockker.translate(true, "cancelled", Lockker.getF().getConfig(), p));
                this.playerlist.remove(p);
                e.setCancelled(true);
            } else {
                p.sendMessage(Lockker.translate(true, "giveKey", Lockker.getF().getConfig(), p));
                int id = ItemUtils.getId("items.key", p, Lockker.getF().getConfig());
                int data = ItemUtils.getData("items.key", p, Lockker.getF().getConfig());
                int count = ItemUtils.getCount("items.key", p, Lockker.getF().getConfig());
                ItemStack ckey = new ItemStack(id, count, (short)((byte)data));
                ItemMeta ckeyM = ckey.getItemMeta();
                ckeyM.setDisplayName("\u00a7e" + msg);
                ckey.setItemMeta(ckeyM);
                p.getInventory().addItem(new ItemStack[]{ckey});
                this.playerlist.remove(p);
                SoundUtils.playSound(p, SoundUtils.givekey);
                e.setCancelled(true);
            }
        }
    }
}

