/*
 * Decompiled with CFR 0.152.
 */
package com.fiveshiphun.chatmanager.commands;

import com.fiveshiphun.chatmanager.MainClass;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MainCommand
implements CommandExecutor {
    MainClass plugin;

    public MainCommand(MainClass sended) {
        this.plugin = sended;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                player.performCommand("chatmanager:chatmanager info");
                return true;
            }
            if (args[0].equalsIgnoreCase("info")) {
                if (!player.hasPermission("chatmanager.info") && !player.hasPermission("chatmanager.all")) {
                    this.noPermission(player);
                    return false;
                }
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&2[&6Info&2] &eChatManager plugin by &7FiveShipHUN"));
                player.sendMessage(ChatColor.YELLOW + "Version: " + ChatColor.GRAY + this.plugin.getDescription().getVersion());
                player.sendMessage(ChatColor.YELLOW + "Release date: " + ChatColor.GRAY + this.plugin.getReleaseDate());
                return true;
            }
            if (args[0].equalsIgnoreCase("words")) {
                if (!player.hasPermission("chatmanager.words") && !player.hasPermission("chatmanager.all")) {
                    this.noPermission(player);
                    return false;
                }
                if (args.length == 1) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Word"));
                    return false;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(this.plugin.getConfig().getStringList("BlockedWords"));
                if (list.contains(args[1])) {
                    list.remove(args[1]);
                    player.sendMessage(this.plugin.getMessage("Messages.WordRemoved"));
                } else {
                    player.sendMessage(this.plugin.getMessage("Messages.WordAdded"));
                    list.add(args[1]);
                }
                this.plugin.getConfig().set("BlockedWords", list);
                this.plugin.saveConfig();
                return true;
            }
            if (args[0].equalsIgnoreCase("busy")) {
                if (!player.hasPermission("chatmanager.busy") && !player.hasPermission("chatmanager.all")) {
                    this.noPermission(player);
                    return false;
                }
                String name = player.getName();
                ArrayList<String> list2 = new ArrayList<String>();
                list2.addAll(this.plugin.getConfig().getStringList("Busy.Players"));
                if (list2.contains(name.toLowerCase())) {
                    list2.remove(name);
                    if (!this.plugin.getConfig().getBoolean("Busy.NotifyPlayers")) {
                        player.sendMessage(this.plugin.getMessage("Messages.Unbusy").replaceAll("%player", player.getName()));
                    } else {
                        Bukkit.broadcastMessage((String)this.plugin.getMessage("Messages.Unbusy").replaceAll("%player", player.getName()));
                    }
                } else {
                    list2.add(name);
                    if (!this.plugin.getConfig().getBoolean("Busy.NotifyPlayers")) {
                        player.sendMessage(this.plugin.getMessage("Messages.Busy").replaceAll("%player", player.getName()));
                    } else {
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            p.sendMessage(this.plugin.getMessage("Messages.Busy").replaceAll("%player", player.getName()));
                        }
                    }
                }
                this.plugin.getConfig().set("Busy.Players", list2);
                this.plugin.saveConfig();
                return true;
            }
            if (args[0].equalsIgnoreCase("reload") && !player.hasPermission("chatmanager.all")) {
                if (!player.hasPermission("chatmanager.reload")) {
                    this.noPermission(player);
                    return false;
                }
                this.plugin.reloadConfig();
                this.plugin.language = this.plugin.getConfig().getString("Language");
                player.sendMessage(this.plugin.getMessage("Messages.Reload"));
                return true;
            }
            if (args[0].equalsIgnoreCase("chat") || args[0].equalsIgnoreCase("mode")) {
                if (!player.hasPermission("chatmanager.chat") && !player.hasPermission("chatmanager.all")) {
                    this.noPermission(player);
                    return false;
                }
                if (args.length == 1) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Chat"));
                    return false;
                }
                if (args[1].equalsIgnoreCase("permission-only")) {
                    this.chatMode("permission-only");
                    return true;
                }
                if (args[1].equalsIgnoreCase("everybody")) {
                    this.chatMode("everybody");
                    return true;
                }
                if (args[1].equalsIgnoreCase("OP-only") && player.isOp()) {
                    this.chatMode("OP-only");
                    return true;
                }
                if (args[1].equalsIgnoreCase("nobody") && player.isOp()) {
                    this.chatMode("nobody");
                    return true;
                }
                player.sendMessage(this.plugin.getMessage("Messages.Help.Chat"));
                return false;
            }
            if (args[0].equalsIgnoreCase("help")) {
                if (!player.hasPermission("chatmanager.help") && !player.hasPermission("chatmanager.all")) {
                    player.sendMessage(this.plugin.getMessage("Messages.NoPermission"));
                    return false;
                }
                for (String string : this.plugin.getConfig().getStringList("Messages.Help.Beginning")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                }
                if (player.hasPermission("chatmanager.info")) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Info"));
                }
                if (player.hasPermission("chatmanager.word")) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Word"));
                }
                if (player.hasPermission("chatmanager.chat")) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Chat"));
                }
                if (player.hasPermission("chatmanager.busy")) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Busy"));
                }
                if (player.hasPermission("chatmanager.reload")) {
                    player.sendMessage(this.plugin.getMessage("Messages.Help.Reload"));
                }
                player.sendMessage(this.plugin.getMessage("Messages.Help.Help"));
                for (String string : this.plugin.getConfig().getStringList("Messages.Help.End")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                }
                return true;
            }
            if (this.plugin.getConfig().getBoolean(String.valueOf(this.plugin.language) + ".Messages.SpigotUnknownCommandMessage")) {
                return false;
            }
            player.sendMessage(this.plugin.getMessage("Messages.UnknownCommand"));
            return false;
        }
        sender.sendMessage(this.plugin.getMessage("Messages.NoConsole"));
        return false;
    }

    public void noPermission(Player player) {
        if (!this.plugin.getConfig().getBoolean("OPCommandsUnknown")) {
            player.sendMessage(this.plugin.getMessage("Messages.NoPermission"));
        } else {
            player.performCommand("blahblahblah:blahblahblahblahblah");
        }
    }

    public void chatMode(String mode) {
        Bukkit.broadcastMessage((String)this.plugin.getMessage("Messages.Chatmode." + mode));
        this.plugin.getConfig().set("Chatmode", (Object)mode);
        this.plugin.saveConfig();
    }
}

