/*
 * Decompiled with CFR 0.152.
 */
package com.fiveshiphun.chatmanager;

import com.fiveshiphun.chatmanager.commands.MainCommand;
import com.fiveshiphun.chatmanager.events.PlayerChat;
import com.fiveshiphun.chatmanager.events.PlayerCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MainClass
extends JavaPlugin {
    private char alternateChar;
    public String language;

    public void onEnable() {
        this.language = "EN";
        this.alternateChar = (char)38;
        PluginDescriptionFile pdf = this.getDescription();
        this.getLogger().info(String.valueOf(pdf.getName()) + " v" + pdf.getVersion() + " enabled!");
        this.getConfig().options().copyDefaults(true);
        this.getConfig().set("Chatmode", (Object)"everybody");
        this.language = this.getConfig().getString("Language");
        this.saveConfig();
        char[] block = this.getConfig().getString("AlternateColorCodeChar").toCharArray();
        this.alternateChar = block[0];
        this.registerEvents();
        this.registerCommands();
    }

    public void onDisable() {
        PluginDescriptionFile pdf = this.getDescription();
        this.getLogger().info(String.valueOf(pdf.getName()) + " v" + pdf.getVersion() + " disabled!");
    }

    public void registerCommands() {
        this.getCommand("chatmanager").setExecutor((CommandExecutor)new MainCommand(this));
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerChat(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerCommand(this), (Plugin)this);
    }

    public String getMessage(String path) {
        return ChatColor.translateAlternateColorCodes((char)this.alternateChar, (String)this.getConfig().getString(String.valueOf(this.language) + "." + path));
    }

    public String getReleaseDate() {
        return "2017.07.07";
    }
}

