/*
 * Decompiled with CFR 0.152.
 */
package us.blockbox.fireworkedit;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import us.blockbox.fireworkedit.ChatColors;

public final class Utils {
    private static final Pattern underscore = Pattern.compile("_", 16);

    private Utils() {
    }

    public static ChatColor getClosestChatColor(Color color) {
        double smallestDist = Double.MAX_VALUE;
        ChatColors smallest = null;
        for (ChatColors cc : ChatColors.values()) {
            double d = Utils.colorDistance(color, cc.color);
            if (!(d < smallestDist)) continue;
            smallestDist = d;
            smallest = cc;
        }
        if (smallest == null) {
            return ChatColor.WHITE;
        }
        return smallest.chatColor;
    }

    private static double colorDistance(Color c1, Color c2) {
        int red1 = c1.getRed();
        int red2 = c2.getRed();
        int rmean = red1 + red2 >> 1;
        int r = red1 - red2;
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        return ((512 + rmean) * r * r >> 8) + 4 * g * g + ((767 - rmean) * b * b >> 8);
    }

    static DyeColor matchDyeColorName(String colorName) {
        for (DyeColor dyeColor : DyeColor.values()) {
            String name = dyeColor.name();
            if (!Utils.matchesIgnoreCaseAndUnderscore(colorName, name)) continue;
            return dyeColor;
        }
        return null;
    }

    static FireworkEffect.Type matchFireworkType(String typeName) {
        for (FireworkEffect.Type type : FireworkEffect.Type.values()) {
            String name = type.name();
            if (!Utils.matchesIgnoreCaseAndUnderscore(typeName, name)) continue;
            return type;
        }
        return null;
    }

    private static boolean matchesIgnoreCaseAndUnderscore(String search, String enumName) {
        return enumName.equalsIgnoreCase(search) || underscore.matcher(enumName).replaceAll("").equalsIgnoreCase(search);
    }

    static List<org.bukkit.Color> matchDyeColorNames(List<String> names) {
        ArrayList<org.bukkit.Color> colors = new ArrayList<org.bukkit.Color>(names.size());
        for (String name : names) {
            DyeColor dyeColor = Utils.matchDyeColorName(name.toUpperCase());
            if (dyeColor == null) continue;
            colors.add(dyeColor.getFireworkColor());
        }
        return colors;
    }

    static void appendCommaSeparatedList(StringBuilder sb, Object[] values) {
        Utils.appendCommaSeparatedList(sb, Arrays.asList(values));
    }

    static void appendCommaSeparatedList(StringBuilder sb, List<?> values) {
        int i = 0;
        int size = values.size();
        while (true) {
            Object o = values.get(i);
            sb.append(o);
            if (++i >= size) break;
            sb.append(", ");
        }
    }
}

