/*
 * Decompiled with CFR 0.152.
 */
package us.blockbox.fireworkedit;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import us.blockbox.fireworkedit.ColorUtils;
import us.blockbox.fireworkedit.Utils;

public class EditCommand
implements CommandExecutor {
    private static final String ACCENT = ChatColor.DARK_AQUA.toString() + ChatColor.BOLD;
    private static final ChatColor FAILED = ChatColor.GRAY;
    private final Map<String, FireworkMetaCommand> effectCommands;

    public EditCommand() {
        LinkedHashMap<String, FireworkMetaCommand> commandMap = new LinkedHashMap<String, FireworkMetaCommand>();
        FireworkMetaCommand commandFlicker = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                Integer posArg = EditCommand.getPosition(p, meta, args);
                if (posArg == null) {
                    return;
                }
                int index = posArg - 1;
                FireworkEffect effect = (FireworkEffect)meta.getEffects().get(index);
                StringBuilder msg = new StringBuilder(ACCENT + "Flicker ");
                boolean hasFlicker = effect.hasFlicker();
                if (hasFlicker) {
                    msg.append("disabled");
                } else {
                    msg.append("enabled");
                }
                FireworkEffect effectNew = FireworkEffect.builder().withColor((Iterable)effect.getColors()).withFade((Iterable)effect.getFadeColors()).with(effect.getType()).flicker(!hasFlicker).trail(effect.hasTrail()).build();
                EditCommand.replaceEffectAt(index, firework, meta, effectNew);
                msg.append(" for effect at position ").append(posArg);
                p.sendMessage(msg.toString());
            }
        };
        FireworkMetaCommand commandTrail = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                Integer posArg = EditCommand.getPosition(p, meta, args);
                if (posArg == null) {
                    return;
                }
                int index = posArg - 1;
                FireworkEffect effect = (FireworkEffect)meta.getEffects().get(index);
                StringBuilder msg = new StringBuilder(ACCENT + "Trail ");
                boolean hasTrail = effect.hasTrail();
                if (hasTrail) {
                    msg.append("disabled");
                } else {
                    msg.append("enabled");
                }
                FireworkEffect effectNew = FireworkEffect.builder().withColor((Iterable)effect.getColors()).withFade((Iterable)effect.getFadeColors()).with(effect.getType()).flicker(effect.hasFlicker()).trail(!hasTrail).build();
                EditCommand.replaceEffectAt(index, firework, meta, effectNew);
                msg.append(" for effect at position ").append(posArg);
                p.sendMessage(msg.toString());
            }
        };
        FireworkMetaCommand commandType = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                FireworkEffect.Type type;
                Integer posArg = EditCommand.getPosition(p, meta, args);
                if (posArg == null) {
                    return;
                }
                FireworkEffect.Type type2 = type = args.size() < 3 ? null : Utils.matchFireworkType(args.get(2));
                if (type == null) {
                    p.sendMessage(FAILED + "You must specify one of the following types:");
                    StringBuilder sb = new StringBuilder();
                    Utils.appendCommaSeparatedList(sb, FireworkEffect.Type.values());
                    p.sendMessage(sb.toString());
                    return;
                }
                int index = posArg - 1;
                FireworkEffect effectOld = (FireworkEffect)meta.getEffects().get(index);
                FireworkEffect effectNew = FireworkEffect.builder().withColor((Iterable)effectOld.getColors()).flicker(effectOld.hasFlicker()).trail(effectOld.hasTrail()).with(type).withFade((Iterable)effectOld.getFadeColors()).build();
                EditCommand.replaceEffectAt(index, firework, meta, effectNew);
                p.sendMessage(ACCENT + "Updated type of effect " + posArg + "!");
                p.sendMessage(EditCommand.buildEffectInfo(index, effectNew).toString());
            }
        };
        FireworkMetaCommand commandPower = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                if (args.size() > 1) {
                    Integer power = Ints.tryParse((String)args.get(1));
                    if (power != null) {
                        if (power <= 3) {
                            if (power >= 1) {
                                meta.setPower(power.intValue());
                                p.sendMessage(ACCENT + "Power set to " + power + ".");
                                firework.setItemMeta((ItemMeta)meta);
                            } else {
                                p.sendMessage(FAILED + "Power cannot be less than 1.");
                            }
                        } else {
                            p.sendMessage(FAILED + "Power cannot be greater than 3.");
                        }
                    }
                } else {
                    p.sendMessage(FAILED + "Specify the power to set.");
                }
            }
        };
        FireworkMetaCommand commandList = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                List effects = meta.getEffects();
                if (effects.isEmpty()) {
                    p.sendMessage(FAILED + "This firework doesn't have any effects.");
                } else {
                    for (int i = 0; i < effects.size(); ++i) {
                        FireworkEffect effect = (FireworkEffect)effects.get(i);
                        StringBuilder sb = EditCommand.buildEffectInfo(i, effect);
                        p.sendMessage(sb.toString());
                    }
                }
            }
        };
        FireworkMetaCommand commandAdd = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                FireworkEffect effect = EditCommand.buildEffectFromArgs(p, args);
                if (effect != null) {
                    int effectsSize = meta.getEffectsSize();
                    meta.addEffect(effect);
                    firework.setItemMeta((ItemMeta)meta);
                    p.sendMessage(EditCommand.buildEffectInfo(effectsSize, effect).toString());
                }
            }
        };
        FireworkMetaCommand commandSet = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                Integer posArg = EditCommand.getPosition(p, meta, args);
                if (posArg == null) {
                    return;
                }
                FireworkEffect effect = EditCommand.buildEffectFromArgs(p, args);
                if (effect != null) {
                    int index = posArg - 1;
                    EditCommand.replaceEffectAt(index, firework, meta, effect);
                    p.sendMessage(ACCENT + "Updated effect " + posArg + "!");
                    p.sendMessage(EditCommand.buildEffectInfo(index, effect).toString());
                }
            }
        };
        FireworkMetaCommand commandRemove = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                Integer posArg = EditCommand.getPosition(p, meta, args);
                if (posArg == null) {
                    return;
                }
                int index = posArg - 1;
                FireworkEffect removedEffect = (FireworkEffect)meta.getEffects().get(index);
                meta.removeEffect(index);
                firework.setItemMeta((ItemMeta)meta);
                p.sendMessage(ACCENT + "Removed effect at position " + posArg);
                p.sendMessage(EditCommand.buildEffectInfo(index, removedEffect).toString());
            }
        };
        FireworkMetaCommand commandColor = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                ColorReplacementArgs replacementArgs = new ColorReplacementArgs(p, meta, args).invoke();
                if (replacementArgs.isFailed()) {
                    return;
                }
                List<org.bukkit.Color> colors = replacementArgs.getColors();
                if (colors == null || colors.isEmpty()) {
                    EditCommand.tellPlayerToSpecifyColors(p);
                } else {
                    Integer posArg = replacementArgs.getPosArg();
                    int index = posArg - 1;
                    FireworkEffect effectOld = (FireworkEffect)meta.getEffects().get(index);
                    FireworkEffect effectNew = FireworkEffect.builder().withColor(colors).flicker(effectOld.hasFlicker()).trail(effectOld.hasTrail()).with(effectOld.getType()).withFade((Iterable)effectOld.getFadeColors()).build();
                    EditCommand.replaceEffectAt(index, firework, meta, effectNew);
                    p.sendMessage(ACCENT + "Updated color of effect " + posArg + "!");
                    p.sendMessage(EditCommand.buildEffectInfo(index, effectNew).toString());
                }
            }
        };
        FireworkMetaCommand commandFade = new FireworkMetaCommand(){

            @Override
            public void execute(Player p, ItemStack firework, FireworkMeta meta, List<String> args) {
                ColorReplacementArgs replacementArgs = new ColorReplacementArgs(p, meta, args).invoke();
                if (replacementArgs.isFailed()) {
                    return;
                }
                List<org.bukkit.Color> colors = replacementArgs.getColors();
                if (colors == null || colors.isEmpty()) {
                    EditCommand.tellPlayerToSpecifyColors(p);
                } else {
                    Integer posArg = replacementArgs.getPosArg();
                    int index = posArg - 1;
                    FireworkEffect effectOld = (FireworkEffect)meta.getEffects().get(index);
                    FireworkEffect effectNew = FireworkEffect.builder().withColor((Iterable)effectOld.getColors()).flicker(effectOld.hasFlicker()).trail(effectOld.hasTrail()).with(effectOld.getType()).withFade(colors).build();
                    EditCommand.replaceEffectAt(index, firework, meta, effectNew);
                    p.sendMessage(ACCENT + "Updated fade color of effect " + posArg + "!");
                    p.sendMessage(EditCommand.buildEffectInfo(index, effectNew).toString());
                }
            }
        };
        commandMap.put("add", commandAdd);
        commandMap.put("remove", commandRemove);
        commandMap.put("list", commandList);
        commandMap.put("set", commandSet);
        commandMap.put("color", commandColor);
        commandMap.put("type", commandType);
        commandMap.put("power", commandPower);
        commandMap.put("fade", commandFade);
        commandMap.put("flicker", commandFlicker);
        commandMap.put("trail", commandTrail);
        this.effectCommands = Collections.unmodifiableMap(new LinkedHashMap(commandMap));
    }

    private static Integer getPosition(Player p, FireworkMeta meta, List<String> args) {
        if (args.size() < 2) {
            p.sendMessage(FAILED + "Specify an effect position.");
            return null;
        }
        Integer posArg = Ints.tryParse((String)args.get(1));
        if (posArg == null) {
            p.sendMessage(FAILED + "Specify an effect position.");
            return null;
        }
        int effectsSize = meta.getEffectsSize();
        if (effectsSize == 0) {
            p.sendMessage(FAILED + "This firework doesn't have any effects.");
        } else if (posArg > effectsSize || posArg < 1) {
            p.sendMessage(FAILED + "Valid effect positions range from 1 to " + effectsSize + ".");
            return null;
        }
        return posArg;
    }

    private static void tellPlayerToSpecifyColors(Player p) {
        p.sendMessage(FAILED + "You must specify at least one of the following colors:");
        StringBuilder sb = new StringBuilder(50);
        Utils.appendCommaSeparatedList(sb, DyeColor.values());
        p.sendMessage(sb.toString());
    }

    private static FireworkEffect buildEffectFromArgs(Player p, List<String> args) {
        FireworkEffect effect = null;
        FireworkEffect.Type type = null;
        ArrayList<org.bukkit.Color> colors = new ArrayList<org.bukkit.Color>();
        boolean flicker = false;
        boolean trail = false;
        if (args.size() > 1) {
            for (String arg : args.subList(1, args.size())) {
                DyeColor matched;
                if (!flicker && "flicker".equalsIgnoreCase(arg)) {
                    flicker = true;
                    continue;
                }
                if (!trail && "trail".equalsIgnoreCase(arg)) {
                    trail = true;
                    continue;
                }
                if (type == null) {
                    type = Utils.matchFireworkType(arg);
                }
                if ((matched = Utils.matchDyeColorName(arg)) == null) continue;
                colors.add(matched.getFireworkColor());
            }
        }
        if (type == null) {
            p.sendMessage(FAILED + "You must specify one of the following types:");
            StringBuilder sb = new StringBuilder();
            Utils.appendCommaSeparatedList(sb, FireworkEffect.Type.values());
            p.sendMessage(sb.toString());
        } else if (colors.isEmpty()) {
            EditCommand.tellPlayerToSpecifyColors(p);
        } else {
            FireworkEffect.Builder fb = FireworkEffect.builder();
            effect = fb.with(type).flicker(flicker).trail(trail).withColor(colors).build();
        }
        return effect;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You must be a player.");
            return true;
        }
        if (!sender.hasPermission("fireworkedit.use")) {
            sender.sendMessage(ChatColor.GRAY + "You don't have permission.");
            return true;
        }
        if (args.length < 1) {
            this.showValidSubcommands(sender);
            return true;
        }
        Player p = (Player)sender;
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (hand == null || hand.getType() != Material.FIREWORK) {
            sender.sendMessage("You must be holding a firework.");
            return true;
        }
        FireworkMeta meta = (FireworkMeta)hand.getItemMeta();
        this.effectSubcommand(p, hand, meta, Arrays.asList(args));
        return true;
    }

    private void effectSubcommand(Player p, ItemStack stack, FireworkMeta meta, List<String> args) {
        String sub = args.get(0);
        FireworkMetaCommand command = this.effectCommands.get(sub.toLowerCase());
        if (command == null) {
            this.showValidSubcommands((CommandSender)p);
        } else {
            command.execute(p, stack, meta, args);
        }
    }

    private static void replaceEffectAt(int index, ItemStack stack, FireworkMeta meta, FireworkEffect effect) {
        ArrayList<FireworkEffect> effects = new ArrayList<FireworkEffect>(meta.getEffects());
        effects.set(index, effect);
        meta.clearEffects();
        meta.addEffects(effects);
        stack.setItemMeta((ItemMeta)meta);
    }

    private static StringBuilder buildEffectInfo(int i, FireworkEffect effect) {
        int lineBreak = 10;
        StringBuilder sb = new StringBuilder(50);
        sb.append(ACCENT).append("Effect ").append(i + 1).append(':').append('\n').append(ChatColor.RESET);
        sb.append(ACCENT).append("Type: ").append(ChatColor.RESET).append(effect.getType());
        if (effect.hasFlicker()) {
            sb.append(" Flicker");
        }
        if (effect.hasTrail()) {
            sb.append(" Trail");
        }
        sb.append('\n').append(ACCENT).append("Colors: ").append(ChatColor.RESET);
        EditCommand.addColorNames(effect.getColors(), sb);
        List fadeColors = effect.getFadeColors();
        if (!fadeColors.isEmpty()) {
            sb.append('\n').append(ACCENT).append("Fade Colors: ").append(ChatColor.RESET);
            EditCommand.addColorNames(fadeColors, sb);
        }
        return sb;
    }

    private void showValidSubcommands(CommandSender sender) {
        sender.sendMessage(ACCENT + "Valid subcommands:");
        StringBuilder sb = new StringBuilder(50);
        Utils.appendCommaSeparatedList(sb, this.effectCommands.keySet().toArray());
        sender.sendMessage(sb.toString());
    }

    private static void addColorNames(List<org.bukkit.Color> colors, StringBuilder sb) {
        List<String> colorNames = EditCommand.getColorNames(colors);
        Utils.appendCommaSeparatedList(sb, colorNames);
    }

    private static List<String> getColorNames(List<org.bukkit.Color> colors) {
        DyeColor[] dyeColors = DyeColor.values();
        Matcher underscore = Pattern.compile("_", 16).matcher("");
        ArrayList<String> names = new ArrayList<String>(colors.size());
        for (org.bukkit.Color color : colors) {
            ChatColor nearestChat = null;
            String colorName = null;
            for (DyeColor dyeColor : dyeColors) {
                org.bukkit.Color fireworkColor = dyeColor.getFireworkColor();
                if (!color.equals((Object)fireworkColor)) continue;
                colorName = WordUtils.capitalizeFully((String)underscore.reset(dyeColor.name()).replaceAll(" "));
                nearestChat = Utils.getClosestChatColor(new Color(fireworkColor.asRGB()));
                break;
            }
            if (colorName == null) {
                int rgb = color.asRGB();
                Color awtColor = new Color(rgb);
                colorName = ColorUtils.getColorNameFromColor(awtColor);
                nearestChat = Utils.getClosestChatColor(awtColor);
                if (colorName == null) {
                    colorName = Integer.toHexString(rgb);
                }
            }
            names.add(nearestChat + colorName + ChatColor.RESET);
        }
        return names;
    }

    private static final class ColorReplacementArgs {
        private boolean failed;
        private final Player p;
        private final FireworkMeta meta;
        private final List<String> args;
        private Integer posArg;
        private List<org.bukkit.Color> colors;

        public ColorReplacementArgs(Player p, FireworkMeta meta, List<String> args) {
            this.p = p;
            this.meta = meta;
            this.args = args;
        }

        boolean isFailed() {
            return this.failed;
        }

        public Integer getPosArg() {
            return this.posArg;
        }

        public List<org.bukkit.Color> getColors() {
            return this.colors;
        }

        public ColorReplacementArgs invoke() {
            if (this.args.size() < 2) {
                this.p.sendMessage(FAILED + "Specify an effect position.");
                this.failed = true;
                return this;
            }
            this.posArg = Ints.tryParse((String)this.args.get(1));
            if (this.posArg == null) {
                this.p.sendMessage(FAILED + "Specify an effect position.");
                this.failed = true;
                return this;
            }
            int effectsSize = this.meta.getEffectsSize();
            if (effectsSize == 0) {
                this.p.sendMessage(FAILED + "This firework doesn't have any effects.");
            } else if (this.posArg > effectsSize || this.posArg < 1) {
                this.p.sendMessage(FAILED + "Valid effect positions range from 1 to " + effectsSize + ".");
                this.failed = true;
                return this;
            }
            this.colors = null;
            if (this.args.size() >= 3) {
                this.colors = Utils.matchDyeColorNames(this.args.subList(2, this.args.size()));
            }
            this.failed = false;
            return this;
        }
    }

    private static interface FireworkMetaCommand {
        public void execute(Player var1, ItemStack var2, FireworkMeta var3, List<String> var4);
    }
}

