/*
 * Decompiled with CFR 0.152.
 */
package com.uddernetworks.bookutils.utils;

import com.google.common.collect.Lists;
import com.uddernetworks.bookutils.command.MessageEnum;
import com.uddernetworks.bookutils.utils.BookAction;
import com.uddernetworks.bookutils.utils.IntegerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBook;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookUtils {
    private final BookAction action;
    private Player player;
    private ItemStack book1;
    private ItemStack book2;
    private Object amount_obj;
    private BookMeta bookMeta;
    private List<IChatBaseComponent> pages;

    public BookUtils(BookAction action, Player player, ItemStack book1, ItemStack book2, Object amount_obj) {
        this.action = action;
        this.player = player;
        this.book1 = book1.clone();
        this.book2 = book2;
        this.amount_obj = amount_obj;
    }

    public ItemStack getNewBook() {
        switch (this.action) {
            case ADDPAGE: {
                if (IntegerUtil.isInteger(this.amount_obj.toString(), 10)) {
                    int amount = Integer.valueOf(this.amount_obj.toString());
                    if (amount > 0) {
                        this.bookMeta = (BookMeta)this.book1.getItemMeta();
                        try {
                            this.pages = (List)CraftMetaBook.class.getDeclaredField("pages").get(this.bookMeta);
                        }
                        catch (ReflectiveOperationException ex) {
                            ex.printStackTrace();
                            this.pages = new ArrayList<IChatBaseComponent>();
                        }
                        for (int i = 0; i < amount; ++i) {
                            IChatBaseComponent page = IChatBaseComponent.ChatSerializer.a((String)ComponentSerializer.toString((BaseComponent)new TextComponent("")));
                            this.pages.add(page);
                        }
                        this.book1.setItemMeta((ItemMeta)this.bookMeta);
                        break;
                    }
                    this.player.sendMessage(MessageEnum.AMOUNT_MUST_BE_OVER_ZERO.getMessage());
                    break;
                }
                this.player.sendMessage(MessageEnum.AMOUNT_MUST_BE_OVER_ZERO.getMessage());
                break;
            }
            case REMOVEPAGE: {
                if (IntegerUtil.isInteger(this.amount_obj.toString(), 10)) {
                    int index = Integer.valueOf(this.amount_obj.toString());
                    if (index > 0) {
                        this.bookMeta = (BookMeta)this.book1.getItemMeta();
                        try {
                            this.pages = (List)CraftMetaBook.class.getDeclaredField("pages").get(this.bookMeta);
                        }
                        catch (ReflectiveOperationException ex) {
                            ex.printStackTrace();
                            this.pages = new ArrayList<IChatBaseComponent>();
                        }
                        if (this.pages.size() > index - 1) {
                            this.pages.remove(index - 1);
                            this.book1.setItemMeta((ItemMeta)this.bookMeta);
                            break;
                        }
                        this.player.sendMessage(MessageEnum.AMOUNT_OVER_PAGE.getMessage());
                        break;
                    }
                    this.player.sendMessage(MessageEnum.AMOUNT_MUST_BE_OVER_ZERO.getMessage());
                    break;
                }
                this.player.sendMessage(MessageEnum.AMOUNT_MUST_BE_OVER_ZERO.getMessage());
                break;
            }
            case TRIM: {
                IChatBaseComponent page2;
                BookMeta bookMeta = (BookMeta)this.book1.getItemMeta();
                try {
                    this.pages = (List)CraftMetaBook.class.getDeclaredField("pages").get(bookMeta);
                }
                catch (ReflectiveOperationException ex) {
                    ex.printStackTrace();
                    this.pages = new ArrayList<IChatBaseComponent>();
                }
                ArrayList<IChatBaseComponent> buffPage = new ArrayList<IChatBaseComponent>(this.pages);
                this.pages.clear();
                List reversePages = new ArrayList();
                for (IChatBaseComponent page2 : new ArrayList<IChatBaseComponent>(buffPage)) {
                    if (page2.getText().equals("")) {
                        buffPage.remove(page2);
                        continue;
                    }
                    reversePages = Lists.reverse(buffPage);
                    break;
                }
                Iterator<Object> iterator = new ArrayList(reversePages).iterator();
                while (iterator.hasNext() && (page2 = (IChatBaseComponent)iterator.next()).getText().equals("")) {
                    buffPage.remove(page2);
                }
                this.pages.addAll(buffPage);
                this.book1.setItemMeta((ItemMeta)bookMeta);
                break;
            }
            case COMBINE: {
                if (this.book2 != null) {
                    List pages2;
                    ArrayList<IChatBaseComponent> pages1;
                    BookMeta bookMeta1 = (BookMeta)this.book1.getItemMeta();
                    BookMeta bookMeta2 = (BookMeta)this.book2.getItemMeta();
                    try {
                        pages1 = (ArrayList<IChatBaseComponent>)CraftMetaBook.class.getDeclaredField("pages").get(bookMeta1);
                        pages2 = (List)CraftMetaBook.class.getDeclaredField("pages").get(bookMeta2);
                    }
                    catch (ReflectiveOperationException ex) {
                        ex.printStackTrace();
                        pages1 = new ArrayList<IChatBaseComponent>();
                        pages2 = new ArrayList();
                    }
                    for (IChatBaseComponent page : pages2) {
                        pages1.add(page);
                    }
                    this.book1.setItemMeta((ItemMeta)bookMeta1);
                    break;
                }
                this.player.sendMessage(MessageEnum.BOOK_OFFHAND.getMessage());
                break;
            }
            case SETAUTHOR: {
                if (this.amount_obj instanceof String) {
                    String author = (String)this.amount_obj;
                    BookMeta bookMeta = (BookMeta)this.book1.getItemMeta();
                    bookMeta.setAuthor(author);
                    this.book1.setItemMeta((ItemMeta)bookMeta);
                    break;
                }
                this.player.sendMessage(MessageEnum.OPTION_MUST_BE_STRING.getMessage());
                break;
            }
            case SETTITLE: {
                if (this.amount_obj instanceof String) {
                    String author = (String)this.amount_obj;
                    BookMeta bookMeta = (BookMeta)this.book1.getItemMeta();
                    bookMeta.setTitle(author);
                    this.book1.setItemMeta((ItemMeta)bookMeta);
                    break;
                }
                this.player.sendMessage(MessageEnum.OPTION_MUST_BE_STRING.getMessage());
                break;
            }
            case UNSIGN: {
                ItemStack book_new = new ItemStack(Material.BOOK_AND_QUILL);
                BookMeta bookMeta = (BookMeta)this.book1.getItemMeta();
                book_new.setItemMeta((ItemMeta)bookMeta);
                return book_new;
            }
            case SETORIGINAL: {
                BookMeta bookMeta = (BookMeta)this.book1.getItemMeta();
                bookMeta.setGeneration(BookMeta.Generation.ORIGINAL);
                this.book1.setItemMeta((ItemMeta)bookMeta);
                break;
            }
        }
        return this.book1;
    }
}

