/*
 * Decompiled with CFR 0.152.
 */
package com.uddernetworks.bookutils.filetype_managers;

import com.uddernetworks.bookutils.utils.IntegerUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFManager {
    private String name;
    private String text;
    private boolean printColor;
    private int fontSize;
    private static final String seperator = "\u00a70#n\u00a70";
    private static final String inLineChars = "\u00a70#n";

    public PDFManager(String name, String text, boolean printColor, int fontSize) {
        this.name = name;
        this.text = text;
        this.printColor = printColor;
        this.fontSize = fontSize;
    }

    public PDFManager(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePDF() {
        PDDocument doc = null;
        try {
            try {
                File parent = new File(this.name).getParentFile();
                if (!parent.exists()) {
                    parent.mkdir();
                }
                doc = new PDDocument();
                PDPage page = new PDPage(PDRectangle.LETTER);
                doc.addPage(page);
                PDPageContentStream contentStream = new PDPageContentStream(doc, page);
                PDType1Font pdfFont = PDType1Font.TIMES_ROMAN;
                float leading = 1.5f * (float)this.fontSize;
                PDRectangle mediabox = page.getMediaBox();
                float margin = 72.0f;
                float width = mediabox.getWidth() - 2.0f * margin;
                float startX = mediabox.getLowerLeftX() + margin;
                float startY = mediabox.getUpperRightY() - margin;
                ArrayList<Object> lines = new ArrayList<String>();
                int lastSpace = -1;
                String text = this.text;
                text = text.replaceAll("\u00a70\n", inLineChars);
                text = text.replaceAll("\n", seperator);
                while (text.length() > 0) {
                    float size;
                    Object subString;
                    int spaceIndex = text.indexOf(32, lastSpace + 1);
                    if (spaceIndex < 0) {
                        spaceIndex = text.length();
                    }
                    if (!PDFManager.isValid(pdfFont, (String)(subString = text.substring(0, spaceIndex)))) {
                        subString = PDFManager.makeValid(pdfFont, (String)subString);
                    }
                    if ((size = (float)this.fontSize * pdfFont.getStringWidth((String)subString) / 1000.0f) > width) {
                        if (lastSpace < 0) {
                            lastSpace = spaceIndex;
                        }
                        subString = text.substring(0, lastSpace);
                        lines.add(subString);
                        text = text.substring(lastSpace).trim();
                        lastSpace = -1;
                        continue;
                    }
                    if (spaceIndex == text.length()) {
                        lines.add(text);
                        text = "";
                        continue;
                    }
                    lastSpace = spaceIndex;
                }
                ArrayList line_clone = new ArrayList(lines);
                lines.clear();
                for (String line : line_clone) {
                    if (line.contains(seperator)) {
                        lines = PDFManager.doStuff(line.replaceAll("\n", "#n"), new ArrayList<String>(lines));
                        continue;
                    }
                    lines.add(line);
                }
                int counter = 0;
                contentStream.beginText();
                contentStream.setFont(pdfFont, this.fontSize);
                contentStream.newLineAtOffset(startX, startY);
                for (String string : lines) {
                    if ((float)counter < startY) {
                        counter = (int)((float)counter + leading);
                        if (this.printColor) {
                            PDFManager.printColor(contentStream, pdfFont, string);
                        } else {
                            System.out.println(string);
                            contentStream.showText(PDFManager.isValid(pdfFont, PDFManager.strip(string)) ? PDFManager.strip(string) : PDFManager.makeValid(pdfFont, PDFManager.strip(string)));
                        }
                        contentStream.newLineAtOffset(0.0f, -leading);
                        continue;
                    }
                    counter = 0;
                    contentStream.endText();
                    contentStream.close();
                    page = new PDPage(PDRectangle.LETTER);
                    doc.addPage(page);
                    contentStream = new PDPageContentStream(doc, page);
                    contentStream.beginText();
                    contentStream.setFont(pdfFont, this.fontSize);
                    contentStream.newLineAtOffset(startX, startY);
                    counter = (int)((float)counter + leading);
                    if (this.printColor) {
                        PDFManager.printColor(contentStream, pdfFont, string);
                    } else {
                        contentStream.showText(PDFManager.isValid(pdfFont, PDFManager.strip(string)) ? PDFManager.strip(string) : PDFManager.makeValid(pdfFont, PDFManager.strip(string)));
                    }
                    contentStream.newLineAtOffset(0.0f, -leading);
                }
                contentStream.endText();
                contentStream.close();
                doc.save(new File(this.name));
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static String strip(String string) {
        return string.replaceAll(inLineChars, "").replaceAll(seperator, "");
    }

    private static ArrayList<String> doStuff(String line, ArrayList<String> original) {
        if (line.contains(seperator)) {
            String temp = line.substring(line.indexOf(seperator));
            String before = temp.substring(temp.indexOf(inLineChars)).replaceAll("\n", "#n");
            if (line.contains(seperator)) {
                original.add(line.substring(0, line.indexOf(seperator)));
            }
            for (int i = 0; i < PDFManager.howManyInline(temp); ++i) {
                original.add("");
            }
            String going_add = before.substring(PDFManager.howManyInline(before) * 4 + 2, before.length());
            if (going_add.contains("#n")) {
                original = PDFManager.doStuff(going_add, new ArrayList<String>(original));
            } else {
                original.add(going_add);
            }
            return original;
        }
        return original;
    }

    private static int howManyInline(String haystack) {
        String[] strs = haystack.replaceAll("\n", "#n").split("(?<=\\G.{4})");
        int ret = 0;
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i].equalsIgnoreCase(inLineChars.replaceAll("\n", "#n"))) {
                ++ret;
                continue;
            }
            i = strs.length;
        }
        return ret;
    }

    private static void printColor(PDPageContentStream contentStream, PDFont pdfFont, String line) throws IOException {
        String[] split_by_chars = line.split("(?<=\\G.)");
        String previous = "";
        for (String character : split_by_chars) {
            boolean printprev = true;
            String prev_buff = "%%%%";
            if (previous.equalsIgnoreCase("\u00a7")) {
                Color color;
                switch (IntegerUtil.isInteger(character, 10) ? character : character.toLowerCase()) {
                    case "0": {
                        color = new Color(0, 0, 0);
                        break;
                    }
                    case "1": {
                        color = new Color(0, 0, 170);
                        break;
                    }
                    case "2": {
                        color = new Color(0, 170, 0);
                        break;
                    }
                    case "3": {
                        color = new Color(0, 170, 170);
                        break;
                    }
                    case "4": {
                        color = new Color(170, 0, 0);
                        break;
                    }
                    case "5": {
                        color = new Color(170, 0, 170);
                        break;
                    }
                    case "6": {
                        color = new Color(255, 170, 0);
                        break;
                    }
                    case "7": {
                        color = new Color(170, 170, 170);
                        break;
                    }
                    case "8": {
                        color = new Color(85, 85, 85);
                        break;
                    }
                    case "9": {
                        color = new Color(85, 85, 255);
                        break;
                    }
                    case "a": {
                        color = new Color(85, 255, 85);
                        break;
                    }
                    case "b": {
                        color = new Color(85, 255, 255);
                        break;
                    }
                    case "c": {
                        color = new Color(255, 85, 85);
                        break;
                    }
                    case "d": {
                        color = new Color(255, 85, 255);
                        break;
                    }
                    case "e": {
                        color = new Color(255, 255, 85);
                        break;
                    }
                    case "f": {
                        color = new Color(255, 255, 255);
                        break;
                    }
                    default: {
                        color = null;
                    }
                }
                if (color != null) {
                    contentStream.setNonStrokingColor(color);
                    prev_buff = "";
                    printprev = false;
                }
            }
            if (printprev) {
                contentStream.showText(previous);
            }
            previous = prev_buff.equalsIgnoreCase("%%%%") ? character : prev_buff;
        }
        contentStream.showText(previous);
    }

    public String readPDF() throws IOException {
        File file = new File("plugins" + File.separator + "SavedBooks" + File.separator + this.name);
        if (!file.exists()) {
            return null;
        }
        new File("plugins", "SavedBooks").mkdirs();
        try (PDDocument document = PDDocument.load(file);){
            PDFTextStripper pdfStripper = new PDFTextStripper();
            String string = pdfStripper.getText(document);
            return string;
        }
    }

    private static boolean isValid(PDFont font, String character) {
        try {
            font.getStringWidth(character);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String makeValid(PDFont font, String string) {
        StringBuilder ret = new StringBuilder();
        for (char character : string.toCharArray()) {
            if (PDFManager.isValid(font, String.valueOf(character))) {
                ret.append(character);
                continue;
            }
            ret.append(" ");
        }
        return ret.toString();
    }
}

