/*
 * Decompiled with CFR 0.152.
 */
package me.eventseen.SpawnTP;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import me.eventseen.SpawnTP.SpawnTP;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PluginFile
extends YamlConfiguration {
    private File file;
    private String defaults;
    private SpawnTP plugin;

    public PluginFile(SpawnTP plugin, String fileName) {
        this(plugin, fileName, null);
    }

    public PluginFile(SpawnTP plugin, String fileName, String defaultsName) {
        this.plugin = plugin;
        this.defaults = defaultsName;
        this.file = new File(plugin.getDataFolder(), fileName);
        this.reloadConfig();
    }

    public void reloadConfig() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
                this.plugin.getLogger().severe("Error while creating file " + this.file.getName());
            }
        }
        try {
            this.load(this.file);
            if (this.defaults != null) {
                InputStreamReader reader = new InputStreamReader(this.plugin.getResource(this.defaults));
                YamlConfiguration defaultsConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                this.setDefaults((Configuration)defaultsConfig);
                this.options().copyDefaults(true);
                reader.close();
                this.saveConfig();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            this.plugin.getLogger().severe("Error while loading file " + this.file.getName());
        }
        catch (InvalidConfigurationException exception) {
            exception.printStackTrace();
            this.plugin.getLogger().severe("Error while loading file " + this.file.getName());
        }
    }

    public void saveConfig() {
        try {
            this.options().indent(2);
            this.save(this.file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            this.plugin.getLogger().severe("Error while saving file " + this.file.getName());
        }
    }

    public FileConfiguration getConfig() {
        return this;
    }
}

