/*
 * Decompiled with CFR 0.152.
 */
package de.sky.manager;

import de.sky.SoupMain;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LocationManager {
    public File file = new File("plugins/" + SoupMain.main.getName(), "locations.yml");
    public FileConfiguration cfg = YamlConfiguration.loadConfiguration((File)this.file);

    public void setLocation(String name, Location loc) {
        this.cfg.set(String.valueOf(name) + ".world", (Object)loc.getWorld().getName());
        this.cfg.set(String.valueOf(name) + ".x", (Object)loc.getX());
        this.cfg.set(String.valueOf(name) + ".y", (Object)loc.getY());
        this.cfg.set(String.valueOf(name) + ".z", (Object)loc.getZ());
        this.cfg.set(String.valueOf(name) + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.cfg.set(String.valueOf(name) + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveCfg();
    }

    public Location getLocation(String name) {
        Location loc;
        try {
            World w = Bukkit.getWorld((String)this.cfg.getString(String.valueOf(name) + ".world"));
            double x = this.cfg.getDouble(String.valueOf(name) + ".x");
            double y = this.cfg.getDouble(String.valueOf(name) + ".y");
            double z = this.cfg.getDouble(String.valueOf(name) + ".z");
            loc = new Location(w, x, y, z);
            loc.setYaw((float)this.cfg.getInt(String.valueOf(name) + ".yaw"));
            loc.setPitch((float)this.cfg.getInt(String.valueOf(name) + ".pitch"));
        }
        catch (Exception ex) {
            loc = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        }
        return loc;
    }

    public void setSpawn(int num, Location loc) {
        String name = "Spawn";
        this.cfg.set(String.valueOf(name) + "." + num + ".world", (Object)loc.getWorld().getName());
        this.cfg.set(String.valueOf(name) + "." + num + ".x", (Object)loc.getX());
        this.cfg.set(String.valueOf(name) + "." + num + ".y", (Object)loc.getY());
        this.cfg.set(String.valueOf(name) + "." + num + ".z", (Object)loc.getZ());
        this.cfg.set(String.valueOf(name) + "." + num + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.cfg.set(String.valueOf(name) + "." + num + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveCfg();
    }

    public Location getSpawn(int num) {
        String name = "Spawn";
        World w = Bukkit.getWorld((String)this.cfg.getString(String.valueOf(name) + "." + num + ".world"));
        double x = this.cfg.getDouble(String.valueOf(name) + "." + num + ".x");
        double y = this.cfg.getDouble(String.valueOf(name) + "." + num + ".y");
        double z = this.cfg.getDouble(String.valueOf(name) + "." + num + ".z");
        Location loc = new Location(w, x, y, z);
        loc.setYaw((float)this.cfg.getInt(String.valueOf(name) + "." + num + ".yaw"));
        loc.setPitch((float)this.cfg.getInt(String.valueOf(name) + "." + num + ".pitch"));
        return loc;
    }

    public void saveCfg() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void mapTeleport() {
        int count = 1;
        for (Player alive : SoupMain.main.alive) {
            alive.teleport(this.getSpawn(count));
            ++count;
        }
    }

    public void setDeathmatch(int num, Location loc) {
        String name = "Deathmatch";
        this.cfg.set(String.valueOf(name) + "." + num + ".world", (Object)loc.getWorld().getName());
        this.cfg.set(String.valueOf(name) + "." + num + ".x", (Object)loc.getX());
        this.cfg.set(String.valueOf(name) + "." + num + ".y", (Object)loc.getY());
        this.cfg.set(String.valueOf(name) + "." + num + ".z", (Object)loc.getZ());
        this.cfg.set(String.valueOf(name) + "." + num + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.cfg.set(String.valueOf(name) + "." + num + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveCfg();
    }

    public Location getDeathmatch(int num) {
        String name = "Deathmatch";
        World w = Bukkit.getWorld((String)this.cfg.getString(String.valueOf(name) + "." + num + ".world"));
        double x = this.cfg.getDouble(String.valueOf(name) + "." + num + ".x");
        double y = this.cfg.getDouble(String.valueOf(name) + "." + num + ".y");
        double z = this.cfg.getDouble(String.valueOf(name) + "." + num + ".z");
        Location loc = new Location(w, x, y, z);
        loc.setYaw((float)this.cfg.getInt(String.valueOf(name) + "." + num + ".yaw"));
        loc.setPitch((float)this.cfg.getInt(String.valueOf(name) + "." + num + ".pitch"));
        return loc;
    }

    public void mapTeleport2() {
        int count = 1;
        for (Player alive : SoupMain.main.alive) {
            alive.teleport(this.getDeathmatch(count));
            ++count;
        }
    }
}

