/*
 * Decompiled with CFR 0.152.
 */
package net.poweredbyawesome.moneyovertime;

import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import net.poweredbyawesome.moneyovertime.events.PlayerInvoiceEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class MoneyOvertime
extends JavaPlugin
implements Listener {
    private static Economy econ = null;
    int time;
    public HashMap<UUID, Integer> invoice = new HashMap();
    public HashMap<String, Permission> perms = new HashMap();

    public void onEnable() {
        this.saveDefaultConfig();
        this.time = this.getConfig().getInt("Time") * 20;
        this.loadPerms();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (!this.setupEconomy()) {
            this.getLogger().log(Level.WARNING, "No vault plugin found, only commands will work!");
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent ev) {
        Player p = ev.getPlayer();
        this.maekMoneh(p, this.getBasicTime(p));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent ev) {
        Player p = ev.getPlayer();
        this.spendMoneh(p);
    }

    public void maekMoneh(Player p, int rtime) {
        if (!this.invoice.containsKey(p.getUniqueId())) {
            if (this.hasWildcard(p) || p.hasPermission("money.overtime.nope")) {
                this.getLogger().log(Level.INFO, p.getName() + " has a wildcard permission \u00af\\_(\u30c4)_/\u00af");
                return;
            }
            this.invoice.put(p.getUniqueId(), Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
                for (String s : this.getConfig().getConfigurationSection("Deposits").getKeys(false)) {
                    if (!p.hasPermission(this.perms.get(s))) continue;
                    if (econ != null) {
                        double amount = this.getConfig().getInt("Deposits." + s + ".amount");
                        PlayerInvoiceEvent playerInvoiceEvent = new PlayerInvoiceEvent(p, amount, s);
                        Bukkit.getPluginManager().callEvent((Event)playerInvoiceEvent);
                        amount = playerInvoiceEvent.getAmount();
                        econ.depositPlayer((OfflinePlayer)p, amount);
                    }
                    if (this.getConfig().getStringList("Deposits." + s + ".commands") == null) continue;
                    for (String command : this.getConfig().getStringList("Deposits." + s + ".commands")) {
                        this.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command.replace("%player%", p.getName()));
                    }
                }
            }, (long)rtime, (long)rtime));
        }
    }

    @Deprecated
    public void spendMoneh(Player p) {
        this.removePlayer(p);
    }

    public int getBasicTime(Player p) {
        for (String s : this.getConfig().getConfigurationSection("Deposits").getKeys(false)) {
            if (!p.hasPermission("money.overtime." + s) || this.getConfig().getString("Deposits." + s + "time") == null) continue;
            return this.getConfig().getInt("Deposits." + s + "time");
        }
        return this.time;
    }

    public boolean removePlayer(Player p) {
        if (this.invoice.containsKey(p.getUniqueId())) {
            Bukkit.getScheduler().cancelTask(this.invoice.get(p.getUniqueId()).intValue());
            this.invoice.remove(p.getUniqueId());
            return true;
        }
        return false;
    }

    public void loadPerms() {
        this.perms.put("ireallyknowwhatimdoingiswear", new Permission("I.Really.Know.What.Im.Doing.I.Swear", PermissionDefault.FALSE));
        for (String s : this.getConfig().getConfigurationSection("Deposits").getKeys(false)) {
            this.perms.put(s, new Permission("money.overtime." + s, PermissionDefault.FALSE));
        }
    }

    public boolean hasWildcard(Player p) {
        return p.hasPermission(this.perms.get("ireallyknowwhatimdoingiswear"));
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }
}

