/*
 * Decompiled with CFR 0.152.
 */
package org.lifeonblack;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.lifeonblack.NoHopper;

public class CraftHopperEvent
implements Listener {
    private NoHopper plugin;

    public CraftHopperEvent(NoHopper plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void craftItemEvent(CraftItemEvent e) {
        if (!this.plugin.getConfig().getBoolean("NoHopper")) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (e.getRecipe().getResult().getType() == Material.HOPPER || e.getRecipe().getResult().getType() == Material.HOPPER_MINECART && !player.hasPermission(this.plugin.getConfig().getString("Permission Node"))) {
            e.setCancelled(true);
            player.closeInventory();
            this.sendMessage(player);
            this.commands(player);
            return;
        }
    }

    public void sendMessage(Player player) {
        if (this.plugin.getConfig().getBoolean("Title")) {
            String[] title = this.plugin.getConfig().getString("TitleMessage").split(",");
            player.sendTitle(this.colorize(title[0]), this.colorize(title[1]));
        } else {
            player.sendMessage(this.colorize(this.plugin.getConfig().getString("Message")));
        }
    }

    public String colorize(String tocolor) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)tocolor);
    }

    public void commands(Player player) {
        if (this.plugin.getConfig().getBoolean("Kickplayer")) {
            player.kickPlayer(this.colorize(this.plugin.getConfig().getString("KickMessage")));
            return;
        }
        if (this.plugin.getConfig().getBoolean("Run Command")) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)this.plugin.getConfig().getString("Command").replace("<player>", player.getName()));
            return;
        }
    }
}

