/*
 * Decompiled with CFR 0.152.
 */
package me.ryans1230.chatchannels.commands;

import java.io.IOException;
import java.util.Map;
import me.ryans1230.chatchannels.ChatChannels;
import me.ryans1230.chatchannels.ConfigUtil;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.config.Configuration;

public class SettingsCommand
extends Command {
    private ChatChannels plugin;

    public SettingsCommand(ChatChannels plugin) {
        super("chatchannelsettings", "chatchannels.owner", new String[]{"ccsettings"});
        this.plugin = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.help(sender);
            sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Here are all the current settings:")));
            for (Map.Entry<Enum, Boolean> e1 : this.plugin.settings.entrySet()) {
                sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&6" + e1.getKey().toString() + " : " + e1.getValue()))));
            }
        } else if (args.length == 1) {
            String setting = args[0];
            boolean value = false;
            boolean sent = true;
            switch (setting) {
                case "owner": {
                    value = this.plugin.settings.get((Object)ChatChannels.Channel.OWNER);
                    break;
                }
                case "developer": {
                    value = this.plugin.settings.get((Object)ChatChannels.Channel.DEVELOPER);
                    break;
                }
                case "admin": {
                    value = this.plugin.settings.get((Object)ChatChannels.Channel.ADMIN);
                    break;
                }
                case "moderator": {
                    value = this.plugin.settings.get((Object)ChatChannels.Channel.MODERATOR);
                    break;
                }
                case "network": {
                    value = this.plugin.settings.get((Object)ChatChannels.Channel.NETWORK);
                    break;
                }
                case "console": {
                    value = this.plugin.settings.get((Object)ChatChannels.Settings.ALLOW_CONSOLE);
                    break;
                }
                case "log": {
                    value = this.plugin.settings.get((Object)ChatChannels.Settings.LOG_MESSAGES);
                    break;
                }
                case "sendDisabled": {
                    value = this.plugin.settings.get((Object)ChatChannels.Settings.SEND_DISABLED);
                    break;
                }
                case "sendDisabledMessages": {
                    value = this.plugin.settings.get((Object)ChatChannels.Settings.SEND_DISABLED);
                    break;
                }
                case "noCommand": {
                    value = this.plugin.settings.get((Object)ChatChannels.Settings.NO_CMD);
                    break;
                }
                default: {
                    this.help(sender);
                    sent = false;
                }
            }
            if (sent) {
                sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&6" + setting + "'s current value is: " + value + "!"))));
            }
        } else if (args.length == 2) {
            String setting = args[0].toLowerCase();
            String value = args[1];
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("enabled")) {
                boolean sent = true;
                Configuration con = ConfigUtil.c;
                switch (setting) {
                    case "owner": {
                        this.plugin.settings.put(ChatChannels.Channel.OWNER, true);
                        con.set("toggles.owner", (Object)true);
                        break;
                    }
                    case "developer": {
                        this.plugin.settings.put(ChatChannels.Channel.DEVELOPER, true);
                        con.set("toggles.developer", (Object)true);
                        break;
                    }
                    case "admin": {
                        this.plugin.settings.put(ChatChannels.Channel.ADMIN, true);
                        con.set("toggles.admin", (Object)true);
                        break;
                    }
                    case "moderator": {
                        this.plugin.settings.put(ChatChannels.Channel.MODERATOR, true);
                        con.set("toggles.moderator", (Object)true);
                        break;
                    }
                    case "network": {
                        this.plugin.settings.put(ChatChannels.Channel.NETWORK, true);
                        con.set("toggles.network", (Object)true);
                        break;
                    }
                    case "console": {
                        this.plugin.settings.put(ChatChannels.Settings.ALLOW_CONSOLE, true);
                        con.set("toggles.allowConsle", (Object)true);
                        break;
                    }
                    case "log": {
                        this.plugin.settings.put(ChatChannels.Settings.LOG_MESSAGES, true);
                        con.set("toggles.logMessages", (Object)true);
                        break;
                    }
                    case "sendDisabled": {
                        this.plugin.settings.put(ChatChannels.Settings.SEND_DISABLED, true);
                        con.set("toggles.sendDisabledMessages", (Object)true);
                        break;
                    }
                    case "sendDisabledMessages": {
                        this.plugin.settings.put(ChatChannels.Settings.SEND_DISABLED, true);
                        con.set("toggles.sendDisabledMessages", (Object)true);
                        break;
                    }
                    case "noCommand": {
                        this.plugin.settings.put(ChatChannels.Settings.NO_CMD, true);
                        con.set("toggles.noCommand", (Object)true);
                        break;
                    }
                    default: {
                        this.help(sender);
                        sent = false;
                    }
                }
                if (sent) {
                    try {
                        ConfigUtil.provider.save(con, ConfigUtil.conf);
                        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&6" + setting + " has been updated to true!"))));
                    }
                    catch (IOException e) {
                        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&cAn internal error occurred!")));
                        e.printStackTrace();
                    }
                }
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("disabled")) {
                boolean sent = true;
                Configuration con = ConfigUtil.c;
                switch (setting) {
                    case "owner": {
                        this.plugin.settings.put(ChatChannels.Channel.OWNER, false);
                        con.set("toggles.owner", (Object)false);
                        break;
                    }
                    case "developer": {
                        this.plugin.settings.put(ChatChannels.Channel.DEVELOPER, false);
                        con.set("toggles.developer", (Object)false);
                        break;
                    }
                    case "admin": {
                        this.plugin.settings.put(ChatChannels.Channel.ADMIN, false);
                        con.set("toggles.admin", (Object)false);
                        break;
                    }
                    case "moderator": {
                        this.plugin.settings.put(ChatChannels.Channel.MODERATOR, false);
                        con.set("toggles.moderator", (Object)false);
                        break;
                    }
                    case "network": {
                        this.plugin.settings.put(ChatChannels.Channel.NETWORK, false);
                        con.set("toggles.network", (Object)false);
                        break;
                    }
                    case "console": {
                        this.plugin.settings.put(ChatChannels.Settings.ALLOW_CONSOLE, false);
                        con.set("toggles.allowConsole", (Object)false);
                        break;
                    }
                    case "log": {
                        this.plugin.settings.put(ChatChannels.Settings.LOG_MESSAGES, false);
                        con.set("toggles.logMessages", (Object)false);
                        break;
                    }
                    case "sendDisabled": {
                        this.plugin.settings.put(ChatChannels.Settings.SEND_DISABLED, false);
                        con.set("toggles.sendDisabledMessages", (Object)false);
                        break;
                    }
                    case "sendDisabledMessages": {
                        this.plugin.settings.put(ChatChannels.Settings.SEND_DISABLED, false);
                        con.set("toggles.sendDisabledMessages", (Object)false);
                        break;
                    }
                    case "noCommand": {
                        this.plugin.settings.put(ChatChannels.Settings.NO_CMD, false);
                        con.set("toggles.noCommand", (Object)false);
                        break;
                    }
                    default: {
                        this.help(sender);
                        sent = false;
                    }
                }
                if (sent) {
                    try {
                        ConfigUtil.provider.save(con, ConfigUtil.conf);
                        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&6" + setting + " has been updated to false!"))));
                    }
                    catch (IOException e) {
                        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&cAn internal error occurred!")));
                        e.printStackTrace();
                    }
                }
            } else {
                this.help(sender);
            }
        } else {
            this.help(sender);
        }
    }

    private void help(CommandSender sender) {
        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&cUsage: /<command> <setting> true/false")));
        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&cSettings: owner | developer | admin | moderator | network | console | log | sendDisabled | sendDisabledMessages | noCommand")));
    }
}

