/*
 * Decompiled with CFR 0.152.
 */
package me.ryans1230.chatchannels;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.ryans1230.chatchannels.ConfigUtil;
import me.ryans1230.chatchannels.NoCommandListener;
import me.ryans1230.chatchannels.commands.AdminChatCommand;
import me.ryans1230.chatchannels.commands.DeveloperChatCommand;
import me.ryans1230.chatchannels.commands.ModeratorChatCommand;
import me.ryans1230.chatchannels.commands.NetworkChatCommand;
import me.ryans1230.chatchannels.commands.OwnerChatCommand;
import me.ryans1230.chatchannels.commands.SettingsCommand;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public final class ChatChannels
extends Plugin {
    public Map<Enum, Boolean> settings = new HashMap<Enum, Boolean>();
    public Map<UUID, Channel> player_storage = new HashMap<UUID, Channel>();

    public void onEnable() {
        ConfigUtil configUtil = new ConfigUtil(this);
        this.getLogger().info("Loading Chat Channels v" + this.getDescription().getVersion() + ". . . .");
        configUtil.createConfig();
        this.settings.put(Settings.ALLOW_CONSOLE, ConfigUtil.c.getBoolean("toggles.allowConsole"));
        this.settings.put(Settings.SEND_DISABLED, ConfigUtil.c.getBoolean("toggles.sendDisabledMessages"));
        this.settings.put(Settings.LOG_MESSAGES, ConfigUtil.c.getBoolean("toggles.logMessages"));
        this.settings.put(Channel.OWNER, ConfigUtil.c.getBoolean("toggles.owner"));
        this.settings.put(Channel.DEVELOPER, ConfigUtil.c.getBoolean("toggles.developer"));
        this.settings.put(Channel.ADMIN, ConfigUtil.c.getBoolean("toggles.admin"));
        this.settings.put(Channel.MODERATOR, ConfigUtil.c.getBoolean("toggles.moderator"));
        this.settings.put(Channel.NETWORK, ConfigUtil.c.getBoolean("toggles.network"));
        this.settings.put(Settings.NO_CMD, ConfigUtil.c.getBoolean("toggles.noCommand"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new OwnerChatCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new DeveloperChatCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new AdminChatCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ModeratorChatCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new NetworkChatCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new SettingsCommand(this));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new NoCommandListener(this));
    }

    public void onDisable() {
        this.getLogger().info("Disabling Chat Channels. . . .");
        try {
            Configuration config = ConfigUtil.provider.load(ConfigUtil.conf);
            config.set("toggles.allowConsole", (Object)this.settings.get((Object)Settings.ALLOW_CONSOLE));
            config.set("toggles.sendDisabledMessages", (Object)this.settings.get((Object)Settings.SEND_DISABLED));
            config.set("toggles.logMessages", (Object)this.settings.get((Object)Settings.LOG_MESSAGES));
            config.set("toggles.owner", (Object)this.settings.get((Object)Channel.OWNER));
            config.set("toggles.developer", (Object)this.settings.get((Object)Channel.DEVELOPER));
            config.set("toggles.admin", (Object)this.settings.get((Object)Channel.ADMIN));
            config.set("toggles.moderator", (Object)this.settings.get((Object)Channel.MODERATOR));
            config.set("toggles.network", (Object)this.settings.get((Object)Channel.NETWORK));
            config.set("toggles.noCommand", (Object)this.settings.get((Object)Settings.NO_CMD));
            ConfigUtil.provider.save(config, ConfigUtil.conf);
        }
        catch (IOException e) {
            this.getLogger().info("Error saving the configuration!");
            e.printStackTrace();
        }
    }

    public void logger(Channel channel, String author, String message) {
        Date now = new Date();
        SimpleDateFormat fileDate = new SimpleDateFormat("MM-dd-yyyy");
        File saveTo = null;
        try {
            switch (channel) {
                case OWNER: {
                    File dataFolder = new File(this.getDataFolder(), "logs/owner/");
                    if (!dataFolder.exists()) {
                        dataFolder.mkdirs();
                    }
                    if ((saveTo = new File(dataFolder, String.valueOf(fileDate.format(now)) + ".log")).exists()) break;
                    saveTo.createNewFile();
                    break;
                }
                case DEVELOPER: {
                    File dataFolder = new File(this.getDataFolder(), "logs/developer/");
                    if (!dataFolder.exists()) {
                        dataFolder.mkdirs();
                    }
                    if ((saveTo = new File(dataFolder, String.valueOf(fileDate.format(now)) + ".log")).exists()) break;
                    saveTo.createNewFile();
                    break;
                }
                case ADMIN: {
                    File dataFolder = new File(this.getDataFolder(), "logs/admin/");
                    if (!dataFolder.exists()) {
                        dataFolder.mkdirs();
                    }
                    if ((saveTo = new File(dataFolder, String.valueOf(fileDate.format(now)) + ".log")).exists()) break;
                    saveTo.createNewFile();
                    break;
                }
                case MODERATOR: {
                    File dataFolder = new File(this.getDataFolder(), "logs/moderator/");
                    if (!dataFolder.exists()) {
                        dataFolder.mkdirs();
                    }
                    if ((saveTo = new File(dataFolder, String.valueOf(fileDate.format(now)) + ".log")).exists()) break;
                    saveTo.createNewFile();
                    break;
                }
                case NETWORK: {
                    File dataFolder = new File(this.getDataFolder(), "logs/network/");
                    if (!dataFolder.exists()) {
                        dataFolder.mkdirs();
                    }
                    if ((saveTo = new File(dataFolder, String.valueOf(fileDate.format(now)) + ".log")).exists()) break;
                    saveTo.createNewFile();
                }
            }
            FileWriter fw = new FileWriter(saveTo, true);
            PrintWriter pw = new PrintWriter(fw);
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
            pw.println("[" + dateFormat.format(now) + "] " + author + ": " + message);
            pw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum Settings {
        ALLOW_CONSOLE,
        SEND_DISABLED,
        LOG_MESSAGES,
        NO_CMD;

    }

    public static enum Channel {
        OWNER,
        DEVELOPER,
        ADMIN,
        MODERATOR,
        NETWORK;

    }
}

