package com;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;

import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;

public class Main  extends Plugin  implements Listener {
	
  public void onEnable() {
    BungeeCord.getInstance().getPluginManager().registerListener(this, this);
    if (!getDataFolder().exists())
        getDataFolder().mkdir();

    File file = new File(getDataFolder(), "config.yml");

 
    if (!file.exists()) {
        try (InputStream in = getResourceAsStream("config.yml")) {
            Files.copy(in, file.toPath());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
  }
  
  public void onDisable() {
	  Configuration configuration;
	try {
		configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(getDataFolder(), "config.yml"));
		  ConfigurationProvider.getProvider(YamlConfiguration.class).save(configuration, new File(getDataFolder(), "config.yml"));
	} catch (IOException e) {
		e.printStackTrace();
	}
  }
  
  @SuppressWarnings("deprecation")
@EventHandler
  public void onPing(ProxyPingEvent e)
  {
	Configuration configuration;
	try {
	configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(getDataFolder(), "config.yml"));
	String mess = configuration.getString("Header");
	 String mess2 = configuration.getString("Footer");
	
    String head = mess;
    String foot = mess2;
    String space = "";
    for (int i = 0; i < (95 - head.length()) / 2; i++) {
      space = space + "";
    }
    head = space + head;
    
    String motd = head + "\n" + foot;
    
    ServerPing p = e.getResponse();
    p.setDescription(ChatColor.translateAlternateColorCodes('&', motd));
    e.setResponse(p);
	} catch (IOException e1) {
		e1.printStackTrace();
	}
  }
}
