/*
 * Decompiled with CFR 0.152.
 */
package wa.was.playerairevents;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import wa.was.playerairevents.events.PlayerFallEvent;
import wa.was.playerairevents.events.PlayerFlyingEvent;
import wa.was.playerairevents.events.PlayerJumpEvent;
import wa.was.playerairevents.events.PlayerLandedEvent;
import wa.was.playerairevents.events.PlayerRisingEvent;
import wa.was.playerairevents.spigot.events.PlayerExitsEvent;

public final class PlayerInAir
extends JavaPlugin
implements Listener {
    private static PlayerInAir instance;
    private Map<UUID, Integer> hasFallen;
    private Map<UUID, Integer> hasJumped;
    private Map<UUID, Boolean> wasAirborn;
    private Map<UUID, Location> fallLocation;

    public static PlayerInAir getInstance() {
        return instance;
    }

    public PlayerInAir() {
        instance = this;
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerExitsEvent(), (Plugin)this);
        this.wasAirborn = new HashMap<UUID, Boolean>();
        this.hasJumped = new HashMap<UUID, Integer>();
        this.hasFallen = new HashMap<UUID, Integer>();
        this.fallLocation = new HashMap<UUID, Location>();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerInAir(PlayerMoveEvent e) {
        int jumped;
        Player player = e.getPlayer();
        if (player.getEyeLocation().getBlock().getType().equals((Object)Material.WATER) || player.getEyeLocation().getBlock().getType().equals((Object)Material.STATIONARY_WATER) || player.getEyeLocation().getBlock().getType().equals((Object)Material.LADDER)) {
            this.resetPlayer(player);
            return;
        }
        if (player.isOnGround()) {
            this.resetPlayer(player);
            return;
        }
        Location f = e.getFrom();
        Location t = e.getTo();
        if (f.getBlock().getY() < t.getBlock().getY() && !f.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR) && t.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR)) {
            if (!this.wasAirborn.containsKey(player.getUniqueId())) {
                this.wasAirborn.put(player.getUniqueId(), true);
            }
            jumped = 1;
            if (this.hasJumped.containsKey(player.getUniqueId())) {
                jumped = this.hasJumped.get(player.getUniqueId());
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerJumpEvent(player, jumped, e.getFrom(), e.getTo()));
        } else if (f.getBlock().getY() < t.getBlock().getY() && t.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR)) {
            if (!this.wasAirborn.containsKey(player.getUniqueId())) {
                this.wasAirborn.put(player.getUniqueId(), true);
            }
            if (this.hasJumped.containsKey(player.getUniqueId())) {
                jumped = this.hasJumped.get(player.getUniqueId());
                this.hasJumped.put(player.getUniqueId(), jumped + 1);
            } else {
                this.hasJumped.put(player.getUniqueId(), 1);
            }
            jumped = this.hasJumped.get(player.getUniqueId());
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerRisingEvent(player, jumped, e.getFrom(), e.getTo()));
        } else if (f.getBlock().getY() > t.getBlock().getY() && t.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR)) {
            if (!this.wasAirborn.containsKey(player.getUniqueId())) {
                this.wasAirborn.put(player.getUniqueId(), true);
            }
            if (!this.fallLocation.containsKey(player.getUniqueId())) {
                this.fallLocation.put(player.getUniqueId(), f.getBlock().getLocation());
            }
            int fallen = (int)Math.abs(this.fallLocation.get(player.getUniqueId()).getY() - t.getBlock().getLocation().getY());
            this.hasFallen.put(player.getUniqueId(), fallen);
            int jumped2 = 1;
            if (this.hasJumped.containsKey(player.getUniqueId())) {
                jumped2 = this.hasJumped.get(player.getUniqueId());
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerFallEvent(player, fallen, jumped2, e.getFrom(), e.getTo(), this.fallLocation.get(player.getUniqueId())));
        } else if (this.wasAirborn.containsKey(player.getUniqueId()) && this.wasAirborn.get(player.getUniqueId()).booleanValue() || t.getBlock().getRelative(BlockFace.DOWN, 1).getType().isSolid() && f.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR)) {
            jumped = 1;
            int fallen = 1;
            if (this.hasJumped.containsKey(player.getUniqueId())) {
                jumped = this.hasJumped.get(player.getUniqueId());
            }
            if (this.hasFallen.containsKey(player.getUniqueId())) {
                fallen = this.hasFallen.get(player.getUniqueId());
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLandedEvent(player, fallen, jumped, e.getFrom(), e.getTo()));
            this.resetPlayer(player);
        }
        if (t.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR) && f.getBlock().getRelative(BlockFace.DOWN, 1).getType().equals((Object)Material.AIR) && !f.getBlock().getLocation().equals((Object)t.getBlock().getLocation())) {
            Block lastBlock = null;
            Block groundBlock = null;
            int toGround = 0;
            int i = 0;
            while (i < f.getWorld().getMaxHeight()) {
                if (!(lastBlock = lastBlock == null ? f.subtract(0.0, 1.0, 0.0).getBlock() : lastBlock.getLocation().subtract(0.0, 1.0, 0.0).getBlock()).getType().equals((Object)Material.AIR)) {
                    groundBlock = lastBlock;
                    toGround = i;
                    break;
                }
                ++i;
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerFlyingEvent(player, e.getFrom(), e.getTo(), toGround, groundBlock));
        }
    }

    public void resetPlayer(Player player) {
        this.hasJumped.remove(player.getUniqueId());
        this.hasFallen.remove(player.getUniqueId());
        this.wasAirborn.put(player.getUniqueId(), false);
        this.fallLocation.remove(player.getUniqueId());
    }
}

