/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.scoreboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class PlayerScoreboard {
    private static HashMap<Player, PlayerScoreboard> boards = new HashMap();
    private Player p;
    private String title;
    private HashMap<Integer, String> content;
    private boolean updateContent;
    private Scoreboard sb;
    private Objective obj;

    public static PlayerScoreboard get(Player p) {
        if (boards.containsKey(p)) {
            return boards.get(p);
        }
        PlayerScoreboard ps = new PlayerScoreboard(p);
        boards.put(p, ps);
        return ps;
    }

    private PlayerScoreboard(Player p) {
        this.p = p;
        this.title = "";
        this.content = null;
        this.sb = null;
        this.obj = null;
        this.updateContent = true;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(ArrayList<String> content) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int blankeds = 9;
        int i = content.size();
        for (String line : content) {
            if (line.equals("BLANK")) {
                map.put(i, "\u00a7" + blankeds);
                --blankeds;
            } else {
                map.put(i, line);
            }
            --i;
        }
        if (this.content != null) {
            this.updateContent = false;
            for (String line : this.content.values()) {
                if (map.containsValue(line)) continue;
                this.updateContent = true;
            }
        } else {
            this.updateContent = true;
        }
        this.content = map;
    }

    public void update() {
        if (!this.updateContent) {
            return;
        }
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        this.sb = manager.getNewScoreboard();
        this.obj = this.sb.registerNewObjective("TechPluginBoard", "dummy");
        this.obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.obj.setDisplayName(this.title);
        this.content.forEach(new BiConsumer<Integer, String>(){

            @Override
            public void accept(Integer integer, String s) {
                Score score = PlayerScoreboard.this.obj.getScore(s);
                score.setScore(integer.intValue());
            }
        });
        this.p.setScoreboard(this.sb);
    }
}

