/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.gui;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFactory {
    protected ItemStack stack;

    public ItemFactory(Material material) {
        this.stack = new ItemStack(material);
    }

    public ItemFactory(Material material, short data) {
        this.stack = data == 0 ? new ItemStack(material) : new ItemStack(material, 1, data);
    }

    public ItemFactory setAmount(int amount) {
        this.stack.setAmount(amount);
        return this;
    }

    public ItemFactory addEnchantment(Enchantment ench, int level) {
        this.stack.addUnsafeEnchantment(ench, level);
        return this;
    }

    public ItemFactory setDisplayName(String name) {
        ItemMeta meta = this.getItemMeta();
        meta.setDisplayName(name);
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemFactory addItemFlag(ItemFlag flag) {
        ItemMeta meta = this.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{flag});
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemFactory addLore(String ... lore) {
        ItemMeta meta = this.getItemMeta();
        meta.setLore(Arrays.asList(lore));
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemFactory addLore(List<String> lore) {
        ItemMeta meta = this.getItemMeta();
        meta.setLore(lore);
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemFactory setDurability(int durability) {
        this.stack.setDurability((short)durability);
        return this;
    }

    public ItemFactory setUnbreakable() {
        ItemMeta meta = this.getItemMeta();
        meta.spigot().setUnbreakable(true);
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemFactory setItemMeta(ItemMeta meta) {
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemStack build() {
        return this.stack;
    }

    protected ItemMeta getItemMeta() {
        return this.stack.getItemMeta();
    }
}

