/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.gui;

import java.util.HashMap;
import me.TechXcrafter.wb.Callback;
import me.TechXcrafter.wb.Chat;
import me.TechXcrafter.wb.TechClass;
import me.TechXcrafter.wb.common.GuiSetting;
import me.TechXcrafter.wb.gui.Element;
import me.TechXcrafter.wb.gui.Missclick;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class InventoryView
implements Listener {
    private Player p;
    private Inventory inv;
    private String title;
    private int size;
    private int starting;
    private TechClass tc;
    private HashMap<Integer, Element> items;
    private Callback<Missclick> no_item;
    private Callback<Missclick> no_action;
    private Callback<Player> close;

    private InventoryView(Player p, GuiSetting setting, TechClass tc) {
        this.p = p;
        this.inv = null;
        this.tc = tc;
        this.no_action = null;
        this.no_item = null;
        this.close = null;
        this.title = setting.getTitle();
        this.size = setting.getSlots();
        this.starting = setting.getStarting();
        this.items = new HashMap();
        if (this.title.length() > 32) {
            for (int i = 32 - this.title.length(); i != 0; ++i) {
                this.title = Chat.removeLastChar(this.title);
            }
        }
    }

    public static InventoryView create(Player p, GuiSetting setting, TechClass tc) {
        return new InventoryView(p, setting, tc);
    }

    public void addItem(Element element) {
        int cursor = this.starting;
        boolean running = true;
        while (cursor < this.size && running) {
            if (this.items.containsKey(++cursor)) continue;
            this.setItem(element, cursor);
            running = false;
            return;
        }
    }

    public void setItem(Element element, int slot) {
        if (this.size < slot) {
            System.out.println("[INV] Error Setting item in Inventory View");
            return;
        }
        this.items.put(slot, element);
        this.update();
    }

    public void removeItem(int slot) {
        this.items.remove(slot);
        if (this.isOpened()) {
            this.inv.remove(slot);
        }
    }

    public void moveItem(int slot1, int slot2) {
        Element element = this.items.get(slot1);
        this.items.remove(slot1);
        this.setItem(element, slot2);
    }

    public void update() {
        if (this.inv == null) {
            return;
        }
        this.inv.clear();
        for (int slot : this.items.keySet()) {
            Element element = this.items.get(slot);
            this.inv.setItem(slot - 1, element.getItemStack());
        }
    }

    public void open() {
        this.tc.getGUIManager().register(this);
        this.inv = this.size == 5 ? Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)this.title) : Bukkit.createInventory(null, (int)this.size, (String)this.title);
        this.update();
        this.p.openInventory(this.inv);
    }

    public void close() {
        if (this.isOpened()) {
            this.p.getPlayer().closeInventory();
        }
    }

    public boolean isOpened() {
        if (this.p.getPlayer().getOpenInventory() == null) {
            return false;
        }
        String open = this.p.getPlayer().getOpenInventory().getTitle();
        return open.equals(this.title);
    }

    public Player getPlayer() {
        return this.p;
    }

    public HashMap<Integer, Element> getItems() {
        return this.items;
    }

    public String getTitle() {
        return this.title;
    }

    public void setClosed() {
        this.inv = null;
        this.tc.getGUIManager().unregister(this);
    }

    public void setNoActionAction(Callback<Missclick> callback) {
        this.no_action = callback;
    }

    public void setNoItemAction(Callback<Missclick> callback) {
        this.no_item = callback;
    }

    public void setCloseAction(Callback<Player> close) {
        this.close = close;
    }

    public Callback<Missclick> getNoActionAction() {
        return this.no_action;
    }

    public Callback<Missclick> getNoItemAction() {
        return this.no_item;
    }

    public Callback<Player> getCloseAction() {
        return this.close;
    }
}

