/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.gui;

import java.util.ArrayList;
import me.TechXcrafter.wb.Module;
import me.TechXcrafter.wb.TechClass;
import me.TechXcrafter.wb.gui.Element;
import me.TechXcrafter.wb.gui.InventoryView;
import me.TechXcrafter.wb.gui.Missclick;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class GUIManager
extends Module {
    private ArrayList<InventoryView> opened;

    public GUIManager(TechClass tc) {
        super("GUI Manager", tc);
    }

    @Override
    public void Enable() {
        this.opened = new ArrayList();
    }

    public void register(InventoryView view) {
        this.opened.add(view);
    }

    public void unregister(InventoryView view) {
        this.opened.remove(view);
    }

    public InventoryView getView(Player p) {
        InventoryView view = null;
        for (InventoryView views : this.opened) {
            if (!views.getPlayer().getName().equals(p.getName())) continue;
            view = views;
        }
        return view;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        InventoryView view = this.getView(p);
        if (view == null) {
            return;
        }
        e.setCancelled(true);
        int clicked = e.getSlot() + 1;
        if (!view.getItems().containsKey(clicked)) {
            if (view.getNoItemAction() == null) {
                return;
            }
            view.getNoItemAction().run(new Missclick(view, p, e.getSlot() + 1));
            return;
        }
        Element element = view.getItems().get(clicked);
        if (element.getAction() == null) {
            if (view.getNoActionAction() == null) {
                return;
            }
            view.getNoActionAction().run(new Missclick(view, p, e.getSlot() + 1));
            return;
        }
        element.getAction().run(p);
        if (view.isOpened()) {
            view.update();
        }
    }

    @EventHandler
    public void on(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        InventoryView view = this.getView(p);
        if (view == null) {
            return;
        }
        if (!e.getInventory().getTitle().equals(view.getTitle())) {
            return;
        }
        view.setClosed();
    }
}

