/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import me.TechXcrafter.wb.TechClass;

public class FileUtil {
    public static File downloadFile(File directory, String name, String url, TechClass tc) throws IOException {
        if (new File(directory.getAbsolutePath() + "/" + name).exists()) {
            return new File(directory.getAbsolutePath() + "/" + name);
        }
        tc.log("Downloading file from web....");
        URL website = new URL(url);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        FileOutputStream fos = new FileOutputStream(directory.getAbsolutePath() + "/" + name);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        return new File(directory.getAbsolutePath() + "/" + name);
    }

    public static URL getURL(File javaArchive) throws IOException {
        return new URL("jar:" + javaArchive.toURI().toURL().toExternalForm() + "!/");
    }

    public static void loadLibrary(File lib, TechClass tc) throws IOException {
        tc.log("Proccessing file " + lib.getName());
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)loader, FileUtil.getURL(lib));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

