/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.config.smart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import me.TechXcrafter.wb.TechClass;
import me.TechXcrafter.wb.common.Bootflag;
import me.TechXcrafter.wb.common.CustomItem;
import me.TechXcrafter.wb.config.smart.SmartValue;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SmartConfig {
    public static ArrayList<SmartConfig> configs = new ArrayList();
    private TechClass tc;
    private String resource;
    private boolean sync;
    private Object obj;
    private File file;
    private FileConfiguration cfg;
    private HashMap<String, Object> cache;

    public SmartConfig(TechClass tc, String resource, boolean sync) {
        this.tc = tc;
        this.resource = resource;
        this.sync = sync;
        this.obj = this;
        this.file = tc.getUsefulMethods().exportFile(resource, false);
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
        if (sync) {
            this.updateConfig();
        }
        this.loadValues();
        this.cache = new HashMap();
        configs.add(this);
    }

    public void reloadConfig() {
        this.cache.clear();
        this.cfg = YamlConfiguration.loadConfiguration((File)new File(this.file.getAbsolutePath()));
        if (this.sync) {
            this.updateConfig();
        }
        this.loadValues();
        this.tc.log("Reloaded " + this.resource);
    }

    public void save() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadValues() {
        SmartConfig obj = this;
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                SmartValue annotation = field.getAnnotation(SmartValue.class);
                if (annotation == null) continue;
                field.setAccessible(true);
                if (this.cfg.contains(annotation.path())) {
                    Object value = this.cfg.get(annotation.path());
                    if (value instanceof String) {
                        value = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)value));
                    }
                    if (value instanceof List) {
                        ListIterator<String> iterator = ((List)value).listIterator();
                        while (iterator.hasNext()) {
                            Object next = iterator.next();
                            if (!(next instanceof String)) continue;
                            iterator.set(ChatColor.translateAlternateColorCodes((char)'&', (String)((String)next)));
                        }
                    }
                    field.set(obj, value);
                    continue;
                }
                if (annotation.defaultsTo().isEmpty()) continue;
                field.set(obj, annotation.defaultsTo());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set config value for field '" + field.getName() + "' in " + clazz, e);
            }
        }
    }

    private void updateConfig() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.file);
        try {
            InputStream is = this.tc.getPlugin().getResource(this.resource);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((InputStream)is);
            boolean changesMade = false;
            for (String key : newConfig.getKeys(true)) {
                if (config.contains(key)) continue;
                config.set(key, newConfig.get(key));
                changesMade = true;
            }
            if (changesMade) {
                config.save(this.file);
                this.tc.log("\u00a7cNew Fields are added to " + this.resource + ", the comments got removed.");
                this.tc.log("\u00a7aIf you wish to get the comments back, simply delete the file and restart.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.cfg;
    }

    public File getFile() {
        return this.file;
    }

    public Object get(String path, boolean cached) {
        if (cached && this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        Object obj = this.cfg.get(path);
        if (this.tc.getBootFlags().contains((Object)Bootflag.DEBUG)) {
            this.tc.log("(" + this.resource + ") " + path + " -> " + obj);
        }
        if (obj instanceof String) {
            obj = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)obj));
        }
        if (obj instanceof ArrayList) {
            ArrayList<String> newList = new ArrayList<String>();
            for (String line : (ArrayList)obj) {
                newList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            this.cache.put(path, newList);
            return newList;
        }
        this.cache.put(path, obj);
        return obj;
    }

    public void set(String path, Object obj, boolean save) {
        this.getConfig().set(path, obj);
        if (save) {
            try {
                this.getConfig().save(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public CustomItem getItem(String path) {
        String itemData = (String)this.get(path + ".id", true);
        List<String> idAndData = Arrays.asList(itemData.split(":"));
        int id = Integer.valueOf(idAndData.get(0));
        byte data = 0;
        if (idAndData.size() == 2) {
            data = Byte.valueOf(idAndData.get(1));
        }
        Material material = Material.getMaterial((int)id);
        String name = (String)this.get(path + ".name", true);
        ArrayList lore = (ArrayList)this.get(path + ".lore", true);
        return CustomItem.make(material, data, name, lore);
    }

    public ConfigurationSection getSection(String path) {
        return this.cfg.getConfigurationSection(path);
    }
}

