/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.config.simple;

import java.util.ArrayList;
import java.util.List;
import me.TechXcrafter.wb.Chat;
import me.TechXcrafter.wb.config.simple.SimpleConfig;

public class SimpleValue<O> {
    private String path;
    private O default_;
    private O cached;
    private SimpleConfig conf;

    public SimpleValue(String path, O default_) {
        this.path = path;
        this.default_ = default_;
        this.cached = null;
    }

    public void assignConfiguration(SimpleConfig conf) {
        this.conf = conf;
    }

    public void addDefault() {
        if (this.default_ != null) {
            this.conf.getFileConfiguration().addDefault(this.path, this.default_);
        }
        if (this.get(true).equals("Reset")) {
            this.reset(true);
            this.conf.getTechClass().log("Resetting Value " + this.path + " to default in " + this.conf.getName());
        }
    }

    public O get(boolean cache) {
        if (cache && this.cached != null) {
            return this.cached;
        }
        this.cached = this.conf.getFileConfiguration().get(this.path);
        if (this.cached instanceof String) {
            this.cached = Chat.convertColor((String)this.cached);
        }
        return this.cached;
    }

    public List<String> getList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.conf.getFileConfiguration().getStringList(this.path)) {
            list.add(Chat.convertColor(s));
        }
        return list;
    }

    public void set(O value, boolean save) {
        this.cached = null;
        this.conf.getFileConfiguration().set(this.path, value);
        if (save) {
            this.conf.saveConfig();
        }
    }

    public void reset(boolean save) {
        this.set(this.default_, save);
    }

    public void flushCache() {
        this.cached = null;
    }
}

