/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.config.simple;

import java.io.File;
import java.io.IOException;
import me.TechXcrafter.wb.TechClass;
import me.TechXcrafter.wb.config.simple.IConfig;
import me.TechXcrafter.wb.config.simple.SimpleValue;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class SimpleConfig
implements IConfig {
    private String path;
    private String name;
    private TechClass tc;
    private File file;
    private FileConfiguration cfg;

    public SimpleConfig(String path, String name, TechClass tc) {
        this.path = path;
        this.name = name;
        this.tc = tc;
        if (this.addNewValues()) {
            this.saveConfig();
            this.loadConfig();
        }
    }

    public void saveConfig() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getFileConfiguration() {
        return this.cfg;
    }

    public boolean addNewValues() {
        boolean newConfig;
        this.file = new File(this.path + "/" + this.name);
        boolean bl = newConfig = !this.file.exists();
        if (!this.file.exists()) {
            this.tc.log("Creating new file... " + this.name);
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.tc.log("Loading file... " + this.name);
        }
        this.loadConfig();
        for (SimpleValue all : this.values()) {
            if (all == null) continue;
            all.assignConfiguration(this);
            all.flushCache();
            all.addDefault();
        }
        this.saveConfig();
        return newConfig;
    }

    private void loadConfig() {
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
        this.cfg.options().copyDefaults(true);
    }

    public void reinitalizeConfig() {
        this.loadConfig();
    }

    public TechClass getTechClass() {
        return this.tc;
    }

    public String getName() {
        return this.name;
    }
}

