/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.common;

import java.util.ArrayList;
import java.util.List;
import me.TechXcrafter.wb.common.StringParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public class CustomItem {
    private Material material;
    private byte data;
    private String name;
    private ArrayList<String> lore;

    private CustomItem(Material material, byte data, String name, ArrayList<String> lore) {
        this.material = material;
        this.data = data;
        this.name = name;
        this.lore = lore;
    }

    public static CustomItem make(Material mat, byte data, String name, ArrayList<String> lore) {
        return new CustomItem(mat, data, name, lore);
    }

    public static CustomItem make(Material mat, byte data) {
        return new CustomItem(mat, data, "", new ArrayList<String>());
    }

    public static CustomItem make(Material mat) {
        return new CustomItem(mat, 0, "", new ArrayList<String>());
    }

    public static CustomItem get(ItemStack is) {
        Material mat = is.getType();
        byte data = is.getData().getData();
        if (is.hasItemMeta()) {
            String name = is.getItemMeta().getDisplayName();
            List lore = is.getItemMeta().getLore();
            return new CustomItem(mat, data, name, new ArrayList<String>(lore));
        }
        return new CustomItem(mat, data, "", new ArrayList<String>());
    }

    public CustomItem setLore(ArrayList<String> lore) {
        this.lore = lore;
        return this;
    }

    public CustomItem setName(String name) {
        this.name = name;
        return this;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialData getMaterialData() {
        return new MaterialData(this.material, this.data);
    }

    public byte getData() {
        return this.data;
    }

    public ItemStack construct() {
        ItemMeta meta;
        ItemStack is = this.data != 0 ? new ItemStack(this.material, 1, (short)this.data) : new ItemStack(this.material);
        if (is.getType() == Material.SKULL_ITEM && !this.name.contains(" ")) {
            meta = (SkullMeta)Bukkit.getItemFactory().getItemMeta(Material.SKULL_ITEM);
            meta.setOwner(ChatColor.stripColor((String)this.name));
            is.setItemMeta(meta);
        }
        meta = is.getItemMeta();
        if (this.name != "") {
            meta.setDisplayName(this.name);
        }
        meta.setLore(this.lore);
        is.setItemMeta(meta);
        return is;
    }

    public void parseThroughLore(StringParser parser) {
        if (this.lore == null) {
            return;
        }
        ArrayList<String> parsedLore = new ArrayList<String>();
        for (String s : this.lore) {
            parsedLore.add(parser.parse(s));
        }
        this.lore = parsedLore;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getLore() {
        return this.lore;
    }
}

