/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import me.TechXcrafter.wb.Chat;
import me.TechXcrafter.wb.Module;
import me.TechXcrafter.wb.TechClass;
import me.TechXcrafter.wb.command.BaseCommand;
import me.TechXcrafter.wb.command.CommandData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandBase
extends Module {
    private File file;
    private FileConfiguration cfg;
    private ArrayList<BaseCommand> commands;

    public CommandBase(TechClass tclass) {
        super("Command Base", tclass);
    }

    @Override
    public void Enable() {
        this.file = new File(this.getTechClass().getPluginDirectory().getAbsolutePath() + "/Commands.yml");
        try {
            this.file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
        this.cfg.options().copyDefaults(true);
        this.commands = new ArrayList();
    }

    public void registerDefaultCommandData(CommandData data) {
        this.cfg.addDefault(data.getCommandname() + ".command", (Object)data.getCommand());
        this.cfg.addDefault(data.getCommandname() + ".prefix", (Object)data.getPrefix());
        this.cfg.addDefault(data.getCommandname() + ".permission", (Object)data.getPermission());
        this.cfg.addDefault(data.getCommandname() + ".enabled", (Object)data.isEnabled());
        this.cfg.addDefault(data.getCommandname() + ".syntax", (Object)data.getSyntax());
        this.cfg.addDefault(data.getCommandname() + ".aliases", (Object)data.getAliases());
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CommandData getCommandData(String commandname) {
        ArrayList<String> syntax = new ArrayList<String>();
        for (String s : this.cfg.getStringList(commandname + ".syntax")) {
            syntax.add(Chat.convertColor(s));
        }
        return new CommandData(commandname, this.cfg.getString(commandname + ".prefix"), this.cfg.getString(commandname + ".command"), this.cfg.getString(commandname + ".permission"), this.cfg.getBoolean(commandname + ".enabled"), syntax.toArray(new String[syntax.size()]), this.cfg.getStringList(commandname + ".aliases").toArray(new String[this.cfg.getStringList(commandname + ".aliases").size()]));
    }

    @EventHandler
    public void cmd(PlayerCommandPreprocessEvent e) {
        String[] args = e.getMessage().split(" ");
        String cmd = args[0].replace("/", "").toLowerCase();
        BaseCommand search = null;
        for (BaseCommand all : this.commands) {
            if (!all.getData().isEnabled() || !all.getData().getPrefix().equalsIgnoreCase("/") || !all.getData().getCommand().equalsIgnoreCase(cmd) && !Arrays.asList(all.getData().getAliases()).contains(cmd)) continue;
            search = all;
        }
        if (search == null) {
            return;
        }
        e.setCancelled(true);
        this.launchCommand(search, e.getPlayer(), args);
    }

    @EventHandler
    public void cmdChat(PlayerChatEvent e) {
        String[] args = e.getMessage().split(" ");
        BaseCommand search = null;
        for (BaseCommand all : this.commands) {
            if (!all.getCommandString().equalsIgnoreCase(args[0]) && !Arrays.asList(all.getData().getAliases()).contains(args[0]) || !all.getData().isEnabled()) continue;
            search = all;
        }
        if (search == null) {
            return;
        }
        e.setCancelled(true);
        this.launchCommand(search, e.getPlayer(), args);
    }

    public void launchCommand(BaseCommand cmd, Player p, String[] args) {
        if (!cmd.getData().getPermission().equalsIgnoreCase("None") && !p.hasPermission(cmd.getData().getPermission())) {
            p.sendMessage(TechClass.getPrefix() + TechClass.getStyleFile().getNoPermission());
            return;
        }
        cmd.execute(p, args);
    }

    public void register(BaseCommand bc) {
        this.commands.add(bc);
    }

    public ArrayList<BaseCommand> getCommands() {
        return this.commands;
    }
}

