/*
 * Decompiled with CFR 0.152.
 */
package me.TechXcrafter.wb;

import java.io.File;
import java.util.ArrayList;
import me.TechXcrafter.wb.Module;
import me.TechXcrafter.wb.UsefulMethods;
import me.TechXcrafter.wb.command.CommandBase;
import me.TechXcrafter.wb.command.HelpCommand;
import me.TechXcrafter.wb.common.Bootflag;
import me.TechXcrafter.wb.config.ReloadConfigCommand;
import me.TechXcrafter.wb.config.StyleFile;
import me.TechXcrafter.wb.files.VersionsFile;
import me.TechXcrafter.wb.gui.GUIManager;
import me.TechXcrafter.wb.task.TaskManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class TechClass {
    private JavaPlugin plugin;
    private String pluginName;
    private ArrayList<Bootflag> bootFlags;
    private File pluginDirectory;
    private File systemDirectory;
    private static StyleFile styleFile;
    private ArrayList<Module> loadedModules;
    private GUIManager guiManager;
    private CommandBase commandBase;
    private UsefulMethods usefulMethods;

    public TechClass(JavaPlugin plugin, String pluginName, boolean paid) {
        this.plugin = plugin;
        this.pluginName = pluginName;
        this.bootFlags = new ArrayList();
        this.usefulMethods = new UsefulMethods(this);
        if (paid) {
            this.bootFlags.add(Bootflag.PAID);
        } else {
            this.bootFlags.add(Bootflag.FREE);
        }
        this.pluginDirectory = this.getPlugin().getDataFolder();
        if (!this.pluginDirectory.exists()) {
            this.bootFlags.add(Bootflag.FIRST_START);
        }
        this.pluginDirectory.mkdir();
        this.systemDirectory = new File(this.pluginDirectory.getAbsolutePath() + "/System");
        this.systemDirectory.mkdir();
        styleFile = new StyleFile(this, "StyleFile.yml");
        if (new File(this.systemDirectory.getAbsolutePath() + "/demo.dat").exists()) {
            this.bootFlags.add(Bootflag.DEMO);
        }
        this.loadedModules = new ArrayList();
        if (this.bootFlags.contains((Object)Bootflag.PAID)) {
            this.log("Thank you for purchasing " + pluginName + " from TechXcrafter");
        }
        this.log("Version: " + this.getVersion());
        if (new VersionsFile(this.systemDirectory.getAbsolutePath(), this).gotUpdate()) {
            this.bootFlags.add(Bootflag.UPDATED);
        }
        new TaskManager(this);
        this.guiManager = new GUIManager(this);
        this.commandBase = new CommandBase(this);
        this.commandBase.register(new HelpCommand(this));
        this.commandBase.register(new ReloadConfigCommand(this));
        if (this.bootFlags.contains((Object)Bootflag.DEBUG)) {
            this.log("\u00a7cDEBUG MODE ACTIVATED! ");
        }
    }

    public void log(String msg) {
        Bukkit.getConsoleSender().sendMessage("\u00a7b[\u00a77" + this.pluginName + "\u00a7b] \u00a7r" + msg);
    }

    public void registerModule(Module m) {
        this.loadedModules.add(m);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public GUIManager getGUIManager() {
        return this.guiManager;
    }

    public static String getPrefix() {
        return styleFile.getPrefix() + " \u00a7r";
    }

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    public File getSystemDirectory() {
        return this.systemDirectory;
    }

    public CommandBase getCommandBase() {
        return this.commandBase;
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public UsefulMethods getUsefulMethods() {
        return this.usefulMethods;
    }

    public static StyleFile getStyleFile() {
        return styleFile;
    }

    public ArrayList<Bootflag> getBootFlags() {
        return this.bootFlags;
    }

    public String getPluginName() {
        return this.pluginName;
    }
}

