/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory.inventory;

import co.binarylife.commandinventory.CommandInventory;
import co.binarylife.commandinventory.data.CIInventoryConfig;
import co.binarylife.commandinventory.inventory.CICommandItem;
import co.binarylife.commandinventory.inventory.CIInventory;
import co.binarylife.commandinventory.util.NumUtil;
import java.util.ArrayList;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;

public class InventoryManager {
    private ArrayList<CIInventory> inventories = new ArrayList();

    public InventoryManager() {
        this.loadInventories();
    }

    public void addInventory(CIInventory inventory) {
        this.inventories.add(inventory);
    }

    public boolean contains(String inventory) {
        for (CIInventory i : this.inventories) {
            if (!i.getID().equalsIgnoreCase(inventory)) continue;
            return true;
        }
        return false;
    }

    public CIInventory getInventory(Inventory inventory) {
        for (CIInventory i : this.inventories) {
            if (!i.getInventory().equals(inventory)) continue;
            return i;
        }
        return null;
    }

    public CIInventory getInventory(String inventory) {
        for (CIInventory i : this.inventories) {
            if (!i.getID().equalsIgnoreCase(inventory)) continue;
            return i;
        }
        return null;
    }

    public ArrayList<CIInventory> getInventories() {
        return this.inventories;
    }

    public void loadInventories() {
        CIInventoryConfig invConfig = CommandInventory.getInstance().getInventoriesConfig();
        FileConfiguration config = invConfig.getConfig();
        for (String k : config.getKeys(false)) {
            ConfigurationSection section = config.getConfigurationSection(k);
            CIInventory inv = new CIInventory(k, section.getString("display-name"), section.getInt("slots"));
            for (String s : section.getKeys(false)) {
                if (!NumUtil.isInt(s)) continue;
                ConfigurationSection item = section.getConfigurationSection(s);
                if (item.contains("command-type")) {
                    inv.setItem(NumUtil.toInteger(s), item.getItemStack("stack"), item.getString("command"), CICommandItem.CommandType.toCommandType(item.getString("command-type")));
                    continue;
                }
                inv.setItem(NumUtil.toInteger(s), item.getItemStack("stack"));
            }
            this.inventories.add(inv);
        }
    }

    public void removeInventory(String name) {
        for (CIInventory i : this.inventories) {
            if (!i.getID().equalsIgnoreCase(name)) continue;
            this.inventories.remove(i);
            return;
        }
    }

    public void removeInventory(CIInventory inventory) {
        this.inventories.remove(inventory);
        CommandInventory.getInstance().getInventoriesConfig().getConfig().set(inventory.getID(), null);
    }

    public void saveInventories() {
        for (CIInventory i : this.inventories) {
            i.save();
        }
        CommandInventory.getInstance().getInventoriesConfig().save();
    }
}

