/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory.inventory;

import co.binarylife.commandinventory.CommandInventory;
import co.binarylife.commandinventory.data.CIInventoryConfig;
import co.binarylife.commandinventory.inventory.CICommandItem;
import co.binarylife.commandinventory.inventory.CIItem;
import java.util.HashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CIInventory {
    private String id;
    private String displayName;
    private int slots;
    private Inventory inventory;
    private HashMap<Integer, CIItem> items;

    public CIInventory(String id, String displayName, int slots) {
        this.id = id;
        this.displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)displayName);
        this.slots = slots;
        this.items = new HashMap();
        if (slots % 9 != 0) {
            slots += 9 - slots % 9;
        }
        this.inventory = CommandInventory.getInstance().getServer().createInventory(null, slots, this.displayName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getID() {
        return this.id;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public CIItem getItem(int slot) {
        return this.items.get(slot);
    }

    public int getSlots() {
        return this.slots;
    }

    public boolean hasItemInSlot(int slot) {
        return this.items.containsKey(slot);
    }

    public boolean hasSlot(int slot) {
        return slot >= 0 && slot < this.slots;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inventory);
    }

    public void removeItem(int slot) {
        this.inventory.remove(slot);
    }

    public void save() {
        CIInventoryConfig invConfig = CommandInventory.getInstance().getInventoriesConfig();
        ConfigurationSection section = invConfig.getConfig().createSection(this.id);
        section.set("display-name", (Object)this.displayName);
        section.set("slots", (Object)this.slots);
        for (int i : this.items.keySet()) {
            ConfigurationSection item = section.createSection("" + i);
            item.set("stack", (Object)this.items.get(i).getItem());
            if (!(this.items.get(i) instanceof CICommandItem)) continue;
            item.set("command", (Object)((CICommandItem)this.items.get(i)).getCommand());
            item.set("command-type", (Object)((CICommandItem)this.items.get(i)).getType().getType());
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setItem(int slot, ItemStack item) {
        this.items.put(slot, new CIItem(item, slot));
        this.inventory.setItem(slot, item);
    }

    public void setItem(int slot, ItemStack item, String command, CICommandItem.CommandType type) {
        this.items.put(slot, new CICommandItem(command, type, item, slot));
        this.inventory.setItem(slot, item);
    }
}

