/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory.inventory;

import co.binarylife.commandinventory.CommandInventory;
import co.binarylife.commandinventory.inventory.CIItem;
import co.binarylife.commandinventory.util.StringUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CICommandItem
extends CIItem {
    private String command;
    private CommandType commandType;

    public CICommandItem(String command, CommandType commandType, ItemStack item, int slot) {
        super(item, slot);
        this.command = command;
        this.commandType = commandType;
    }

    public void executeCommand(Player player) {
        if (this.commandType.equals((Object)CommandType.PLAYER)) {
            player.performCommand(StringUtil.replacePlayer(this.command, player));
        } else {
            CommandInventory plugin = CommandInventory.getInstance();
            plugin.getServer().dispatchCommand((CommandSender)plugin.getServer().getConsoleSender(), StringUtil.replacePlayer(this.command, player));
        }
    }

    public String getCommand() {
        return this.command;
    }

    public CommandType getType() {
        return this.commandType;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public static enum CommandType {
        CONSOLE("Console"),
        PLAYER("Player");

        private String type;

        private CommandType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static CommandType toCommandType(String type) {
            if (type.equalsIgnoreCase("console")) {
                return CONSOLE;
            }
            if (type.equalsIgnoreCase("player")) {
                return PLAYER;
            }
            return null;
        }
    }
}

