/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory.commands;

import co.binarylife.commandinventory.commands.CICommand;
import co.binarylife.commandinventory.inventory.CIInventory;
import co.binarylife.commandinventory.inventory.InventoryManager;
import co.binarylife.commandinventory.util.NumUtil;
import co.binarylife.commandinventory.util.StringUtil;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public class CreateInventoryCommand
extends CICommand<CommandSender> {
    private InventoryManager im;

    public CreateInventoryCommand(InventoryManager im) {
        super("createinventory", "<id> <slots> <display name>", "Creates specified inventory, identifiable via ID.", "commandinventory.addcommanditem", CommandSender.class, 3);
        this.im = im;
    }

    @Override
    public void run(String[] args, CommandSender sender) {
        if (this.im.getInventory(args[0]) != null) {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + "An inventory with that ID already exists!");
            return;
        }
        if (!NumUtil.isInt(args[1])) {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + this.getUsage());
            return;
        }
        int slots = NumUtil.toInteger(args[1]);
        this.im.addInventory(new CIInventory(args[0], StringUtil.formatEndOfArgs(args, 2), slots));
        sender.sendMessage(String.valueOf(StringUtil.PREFIX) + StringUtil.SECONDARY_COLOR + args[0] + StringUtil.PRIMARY_COLOR + " was created with " + this.im.getInventory(args[0]).getSlots() + " slots!");
    }
}

