/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory.commands;

import co.binarylife.commandinventory.commands.AddCommandItemCommand;
import co.binarylife.commandinventory.commands.AddItemCommand;
import co.binarylife.commandinventory.commands.CICommand;
import co.binarylife.commandinventory.commands.CreateInventoryCommand;
import co.binarylife.commandinventory.commands.InventoryInfoCommand;
import co.binarylife.commandinventory.commands.ListInventoriesCommand;
import co.binarylife.commandinventory.commands.OpenInventoryCommand;
import co.binarylife.commandinventory.commands.RemoveInventoryCommand;
import co.binarylife.commandinventory.inventory.InventoryManager;
import co.binarylife.commandinventory.util.StringUtil;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandManager
implements CommandExecutor {
    private ArrayList<CICommand<?>> commands = new ArrayList();

    public CommandManager(InventoryManager im) {
        this.commands.add(new AddItemCommand(im));
        this.commands.add(new AddCommandItemCommand(im));
        this.commands.add(new CreateInventoryCommand(im));
        this.commands.add(new InventoryInfoCommand(im));
        this.commands.add(new ListInventoriesCommand(im));
        this.commands.add(new OpenInventoryCommand(im));
        this.commands.add(new RemoveInventoryCommand(im));
    }

    private String[] formatArgs(String[] args) {
        String[] formattedArgs = new String[args.length - 1];
        int i = 1;
        while (i < args.length) {
            formattedArgs[i - 1] = args[i];
            ++i;
        }
        return formattedArgs;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdLabel, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + "/ci <args...>");
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            sender.sendMessage(StringUtil.HEADER);
            sender.sendMessage(StringUtil.PRIMARY_COLOR + "Help" + StringUtil.SECONDARY_COLOR + " - " + StringUtil.TERTIARY_COLOR + "Shows all SkyLotto commands!");
            for (CICommand<?> c : this.commands) {
                sender.sendMessage(StringUtil.PRIMARY_COLOR + c.getCommand() + StringUtil.SECONDARY_COLOR + " - " + StringUtil.TERTIARY_COLOR + c.getDescription());
            }
            return true;
        }
        CICommand<?> command = null;
        for (CICommand<?> c : this.commands) {
            if (!c.getCommand().equalsIgnoreCase(args[0])) continue;
            command = c;
            break;
        }
        if (command == null) {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + "That command does not exist!");
            return true;
        }
        if (!command.getType().isInstance(sender)) {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + "You must be a player to use that command!");
            return true;
        }
        if ((args = this.formatArgs(args)).length < command.getArgsLength()) {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + command.getUsage());
            return true;
        }
        command.handle(sender, args);
        return true;
    }
}

