/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory.commands;

import co.binarylife.commandinventory.util.StringUtil;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class CICommand<T extends CommandSender> {
    private final Class<T> TYPE;
    private String command;
    private int argsLength;
    private String usage;
    private String description;
    private String node;

    public CICommand(String command, String usage, String description, String node, Class<T> type, int argsLength) {
        this.command = command;
        this.argsLength = argsLength;
        this.usage = usage;
        this.description = description;
        this.node = node;
        this.TYPE = type;
    }

    public int getArgsLength() {
        return this.argsLength;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.command;
    }

    public Class<T> getType() {
        return this.TYPE;
    }

    public String getUsage() {
        return "/ci " + this.command + " " + this.usage;
    }

    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.node);
    }

    final void handle(CommandSender sender, String[] args) {
        if (this.hasPermission(sender)) {
            this.run(args, sender);
        } else {
            sender.sendMessage(String.valueOf(StringUtil.PREFIX) + ChatColor.RED + "You must be a player with permission to execute this command!");
        }
    }

    public abstract void run(String[] var1, T var2);
}

