/*
 * Decompiled with CFR 0.152.
 */
package co.binarylife.commandinventory;

import co.binarylife.commandinventory.commands.CommandManager;
import co.binarylife.commandinventory.data.CIConfig;
import co.binarylife.commandinventory.data.CIInventoryConfig;
import co.binarylife.commandinventory.inventory.InventoryManager;
import co.binarylife.commandinventory.listeners.CommandItemClick;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandInventory
extends JavaPlugin {
    private static CommandInventory instance;
    private InventoryManager im;
    private CIConfig config;
    private CIInventoryConfig invConfig;

    public void onLoad() {
        instance = this;
    }

    public static CommandInventory getInstance() {
        return instance;
    }

    public void onEnable() {
        Logger logger = this.getLogger();
        logger.info("Loading CommandInventory");
        logger.info("Loading Inventories Config...");
        this.invConfig = new CIInventoryConfig();
        logger.info("Config loaded");
        logger.info("Loading inventories...");
        this.im = new InventoryManager();
        logger.info("Inventories loaded");
        logger.info("Loading commands...");
        this.loadCommands();
        logger.info("Commands loaded");
        logger.info("Loading events...");
        this.getServer().getPluginManager().registerEvents((Listener)new CommandItemClick(this.im), (Plugin)this);
        logger.info("Events loaded");
        logger.info("CommandInventory Loaded");
    }

    public void onDisable() {
        this.im.saveInventories();
    }

    private void loadCommands() {
        CommandManager cm = new CommandManager(this.im);
        this.getCommand("ci").setExecutor((CommandExecutor)cm);
        this.getCommand("commandinventory").setExecutor((CommandExecutor)cm);
    }

    public CIConfig getPluginConfig() {
        return this.config;
    }

    public CIInventoryConfig getInventoriesConfig() {
        return this.invConfig;
    }
}

