/*
 * Decompiled with CFR 0.152.
 */
package com.forgedfactions.randomcommandtimer;

import com.forgedfactions.randomcommandtimer.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RandomTimer
extends JavaPlugin {
    private static final List<Command> commandList = new ArrayList<Command>();
    private final List<String> names = new ArrayList<String>();
    String VERSION = "3.1.7";

    public void onEnable() {
        this.saveDefaultConfig();
        this.registerCommands();
        Bukkit.getServer().getConsoleSender().sendMessage("~~~~~~~~~~~~~~~~[RCT]~~~~~~~~~~~~~~~~");
        Bukkit.getServer().getConsoleSender().sendMessage("RandomTimedCommands is now enabled!");
        Bukkit.getServer().getConsoleSender().sendMessage("Version " + this.VERSION);
        Bukkit.getServer().getConsoleSender().sendMessage("Developed by play.forgedfactions.com");
        Bukkit.getServer().getConsoleSender().sendMessage("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public void onDisable() {
        this.saveConfig();
        Bukkit.getServer().getConsoleSender().sendMessage("~~~~~~~~~~~~~~~~[RCT]~~~~~~~~~~~~~~~~");
        Bukkit.getServer().getConsoleSender().sendMessage("RandomTimedCommands is now disabled");
        Bukkit.getServer().getConsoleSender().sendMessage("Version " + this.VERSION);
        Bukkit.getServer().getConsoleSender().sendMessage("Developed by play.forgedfactions.com");
        Bukkit.getServer().getConsoleSender().sendMessage("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("rct")) {
            if (sender.hasPermission("rct.admin")) {
                if (args.length > 0) {
                    if (args[0].equalsIgnoreCase("reload")) {
                        this.saveConfig();
                        this.reloadConfig();
                        this.registerCommands();
                        Bukkit.getPluginManager().disablePlugin((Plugin)this);
                        Bukkit.getPluginManager().enablePlugin((Plugin)this);
                        sender.sendMessage(ChatColor.GREEN.toString() + "[RCT] RCT was successfully reloaded!");
                    } else if (args[0].equalsIgnoreCase("help")) {
                        this.sendHelp(sender);
                    } else if (args[0].equalsIgnoreCase("list")) {
                        this.listCommands(sender);
                    } else if (this.names.contains(args[0])) {
                        if (RandomTimer.getIndex(args[0]) != -1) {
                            int index = RandomTimer.getIndex(args[0]);
                            if (args.length > 1) {
                                if (args[1].equalsIgnoreCase("start") && index != -1) {
                                    this.startCommand(sender, args, index);
                                } else if (args[1].equalsIgnoreCase("stop") && index != -1) {
                                    this.stopCommand(sender, args, index);
                                } else if (args[1].equalsIgnoreCase("execute")) {
                                    this.executeCommand(sender, args, index);
                                } else if (args[1].equalsIgnoreCase("time")) {
                                    sender.sendMessage("Time left on " + args[0] + ": " + (commandList.get(index).getRand() - commandList.get(index).getCycles()) + " seconds.");
                                }
                            } else {
                                sender.sendMessage(ChatColor.RED.toString() + "[RCT] Please use 'start', 'stop', 'execute', or 'time'");
                            }
                        } else {
                            sender.sendMessage(ChatColor.RED.toString() + "[RCT] '" + args[0] + "' was not found in registered commands!");
                        }
                    } else {
                        sender.sendMessage(ChatColor.RED.toString() + "[RCT] '" + args[0] + "' is not a valid command!");
                        sender.sendMessage(ChatColor.RED.toString() + "[RCT] Please use 'start', 'stop', 'execute', or 'time'");
                    }
                } else {
                    this.sendHelp(sender);
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[RCT] No permission to execute this command!");
            }
            return true;
        }
        return false;
    }

    private void startCommand(CommandSender sender, final String[] args, final int index) {
        if (commandList.get(index).getRunning()) {
            sender.sendMessage(ChatColor.RED.toString() + "[RTC] '" + args[0] + "' is already running!");
        } else {
            commandList.get(index).setRand(commandList.get(index).getMin() + (int)(Math.random() * (double)(commandList.get(index).getMax() - commandList.get(index).getMin() + 1)));
            commandList.get(index).setRunning(true);
            commandList.get(index).setId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    if (((Command)commandList.get(index)).getCycles() >= ((Command)commandList.get(index)).getRand()) {
                        RandomTimer.this.runCommands(args, index);
                        ((Command)commandList.get(index)).setRand(((Command)commandList.get(index)).getMin() + (int)(Math.random() * (double)(((Command)commandList.get(index)).getMax() - ((Command)commandList.get(index)).getMin() + 1)));
                        ((Command)commandList.get(index)).setCycles(0);
                    }
                    ((Command)commandList.get(index)).setCycles(((Command)commandList.get(index)).getCycles() + 1);
                }
            }, 20L, 20L));
            sender.sendMessage(ChatColor.GREEN.toString() + "[RCT] '" + args[0] + "' was successfully started! '" + commandList.get(index).getRand() + "' seconds until next execution.");
        }
    }

    private void stopCommand(CommandSender sender, String[] args, int index) {
        if (commandList.get(index).getRunning()) {
            Bukkit.getScheduler().cancelTask(commandList.get(index).getId());
            commandList.get(index).setRunning(false);
            sender.sendMessage(ChatColor.GREEN.toString() + "[RCT] '" + args[0] + "' was successfully stopped!");
        } else {
            sender.sendMessage(ChatColor.RED.toString() + "[RCT] '" + args[0] + "' is not currently running. \nUse '/rct " + args[0] + " start' to start running the command.");
        }
    }

    private void executeCommand(CommandSender sender, String[] args, int index) {
        commandList.get(index).setRand(commandList.get(index).getMin() + (int)(Math.random() * (double)(commandList.get(index).getMax() - commandList.get(index).getMin() + 1)));
        commandList.get(index).setCycles(0);
        this.runCommands(args, index);
        sender.sendMessage(ChatColor.GREEN + "[RCT] '" + args[0] + "' was successfully executed!");
    }

    private void runCommands(String[] args, int index) {
        for (int i = 0; i < commandList.get(index).getCommands().size(); ++i) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), commandList.get(index).getCommands().get(i));
        }
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN.toString() + args[0] + "' was successfully executed! '" + commandList.get(index).getRand() + "' seconds until next execution.");
    }

    private void listCommands(CommandSender sender) {
        sender.sendMessage("~~~~~~~~~~~[RCT Commands]~~~~~~~~~~~~");
        for (int i = 0; i < commandList.size(); ++i) {
            sender.sendMessage("* " + commandList.get(i).getName());
        }
        sender.sendMessage("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    private void registerCommands() {
        for (int i = 0; i < commandList.size(); ++i) {
            if (!commandList.get(i).getRunning()) continue;
            Bukkit.getScheduler().cancelTask(commandList.get(i).getId());
        }
        commandList.clear();
        for (String key : this.getConfig().getConfigurationSection("schedule").getKeys(false)) {
            this.names.add(key);
            int min = this.getConfig().getInt("schedule." + key + ".mintime");
            int max = this.getConfig().getInt("schedule." + key + ".maxtime");
            List comms = this.getConfig().getStringList("schedule." + key + ".commands");
            RandomTimer.addCommand(new Command(key, min, max, comms));
        }
    }

    private static int getIndex(String name) {
        for (int i = 0; i < commandList.size(); ++i) {
            if (!commandList.get(i).getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("~~~~~~~~~~~~~~~[RCT Help]~~~~~~~~~~~~~~~~");
        sender.sendMessage("/rct reload");
        sender.sendMessage("- reload the plugin");
        sender.sendMessage("/rct <commandname> start/stop/execute/time");
        sender.sendMessage("- start or stop a command");
        sender.sendMessage("- execute a command immediately");
        sender.sendMessage("- display time left until next execution");
        sender.sendMessage("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    private static void addCommand(Command com) {
        commandList.add(com);
    }
}

