/*
 * Decompiled with CFR 0.152.
 */
package de.fabb111.joinme.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import net.md_5.bungee.api.ChatColor;

public class Image {
    private static final Color[] colors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 170), new Color(0, 170, 0), new Color(0, 170, 170), new Color(170, 0, 0), new Color(170, 0, 170), new Color(255, 170, 0), new Color(170, 170, 170), new Color(85, 85, 85), new Color(85, 85, 255), new Color(85, 255, 85), new Color(85, 255, 255), new Color(255, 85, 85), new Color(255, 85, 255), new Color(255, 255, 85), new Color(255, 255, 255)};

    public static ChatColor[][] toChatColorArray(BufferedImage image, int height) {
        double ratio = image.getHeight() / image.getWidth();
        int width = (int)((double)height / ratio);
        BufferedImage resized = Image.resizeImage(image, width, height);
        ChatColor[][] chatImg = new ChatColor[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (int y = 0; y < resized.getHeight(); ++y) {
                ChatColor closest;
                int rgb = resized.getRGB(x, y);
                chatImg[x][y] = closest = Image.getClosestChatColor(new Color(rgb));
            }
        }
        return chatImg;
    }

    public static String[] toImgMessage(ChatColor[][] colors, char imgchar) {
        String[] lines = new String[colors[0].length];
        for (int y = 0; y < colors[0].length; ++y) {
            String line = "";
            for (int x = 0; x < colors.length; ++x) {
                line = line + colors[x][y].toString() + imgchar;
            }
            lines[y] = line + ChatColor.RESET;
        }
        return lines;
    }

    public static String[] appendTextToImg(String[] chatImg, String ... text) {
        for (int y = 0; y < chatImg.length; ++y) {
            if (text.length <= y) continue;
            chatImg[y] = chatImg[y] + " " + text[y];
        }
        return chatImg;
    }

    public static String[] appendTextToImg(String[] chatImg, Iterable<String> text) {
        Iterator<String> i = text.iterator();
        for (int idx = 0; idx < chatImg.length && i.hasNext(); ++idx) {
            String toAppend = i.next();
            chatImg[idx] = chatImg[idx] + " " + toAppend;
        }
        return chatImg;
    }

    public static String[] appendCenteredTextToImg(String[] chatImg, String ... text) {
        for (int y = 0; y < chatImg.length; ++y) {
            if (text.length <= y) {
                return chatImg;
            }
            int len = 65 - chatImg[y].length();
            chatImg[y] = chatImg[y] + Image.center(text[y], len);
        }
        return chatImg;
    }

    public static String center(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        if (s.length() == length) {
            return s;
        }
        int leftPadding = (length - s.length()) / 2;
        StringBuilder leftBuilder = new StringBuilder();
        for (int i = 0; i < leftPadding; ++i) {
            leftBuilder.append(" ");
        }
        return leftBuilder.toString() + s;
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 6);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }

    private static ChatColor getClosestChatColor(Color c) {
        int i;
        if (c.getAlpha() < 128) {
            return null;
        }
        int index = 0;
        double best = -1.0;
        for (i = 0; i < colors.length; ++i) {
            if (!Image.areIdentical(colors[i], c)) continue;
            return ChatColor.values()[i];
        }
        for (i = 0; i < colors.length; ++i) {
            double distance = Image.getDistance(c, colors[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        return ChatColor.values()[index];
    }

    private static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    private static boolean areIdentical(Color c1, Color c2) {
        return Math.abs(c1.getRed() - c2.getRed()) <= 5 && Math.abs(c1.getGreen() - c2.getGreen()) <= 5 && Math.abs(c1.getBlue() - c2.getBlue()) <= 5;
    }
}

