/*
 * Decompiled with CFR 0.152.
 */
package de.fabb111.joinme.commands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.fabb111.joinme.Main;
import de.fabb111.joinme.api.JoinMeAPI;
import de.fabb111.joinme.api.JoinMeMessage;
import java.awt.image.BufferedImage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.config.Configuration;

public class JoinMeCommand
extends Command {
    private static final Object LOCK = new Object();
    private static final String KEY_NOT_FOUND = "???";
    private static final Map<String, JoinMeInfo> CODES = new HashMap<String, JoinMeInfo>();
    private static final Map<String, Long> lastSentGlobalJoinMe = new HashMap<String, Long>();
    private static final Map<UUID, Map<String, Long>> lastSentPlayerJoinMe = new HashMap<UUID, Map<String, Long>>();
    private final Main instance;
    private final String charset;
    private final int length;
    private final int validTime;
    private final ClearCacheMethod clearCacheMethod;
    private final int globalCooldown;
    private final int individualCooldown;
    private ScheduledTask timedClearCacheMethodTask;

    public JoinMeCommand(Main instance) {
        this(instance, "joinme", new String[0]);
    }

    public JoinMeCommand(Main instance, String name, String ... aliases) {
        super(name, null, aliases);
        this.instance = instance;
        this.charset = instance.getSettings().getConfig().getString("JoinCodes.Charset", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        this.length = instance.getSettings().getConfig().getInt("JoinCodes.Length", 5);
        this.validTime = instance.getSettings().getConfig().getInt("JoinCodes.ValidTime", 30);
        this.clearCacheMethod = ClearCacheMethod.valueOf(instance.getSettings().getConfig().getString("Cache.Clear", "NEVER"));
        if (this.clearCacheMethod == ClearCacheMethod.TIMED) {
            this.startTimedClearCacheMethod();
        }
        this.globalCooldown = instance.getSettings().getConfig().getInt("Command.Cooldown.Global", 10);
        this.individualCooldown = instance.getSettings().getConfig().getInt("Command.Cooldown.Individual", 30);
    }

    public void execute(CommandSender sender, String[] args) {
        switch (args.length) {
            case 0: {
                if (sender.hasPermission(this.instance.getSettings().getConfig().getString("Permissions.UseJoinMe", "joinme.use"))) {
                    if (sender instanceof ProxiedPlayer) {
                        ProxiedPlayer p = (ProxiedPlayer)sender;
                        sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.JoinMeCommand.Start", KEY_NOT_FOUND))));
                        if (this.instance.getSettings().getConfig().getBoolean("Servers.UseWhitelist", false) ? JoinMeCommand.containsServer(this.instance.getSettings().getConfig().getStringList("Servers.Whitelist"), p.getServer().getInfo().getName()) : !JoinMeCommand.containsServer(this.instance.getSettings().getConfig().getStringList("Servers.Blacklist"), p.getServer().getInfo().getName())) {
                            try {
                                if (TimeUnit.SECONDS.convert(System.currentTimeMillis() - lastSentGlobalJoinMe.getOrDefault(p.getServer().getInfo().getName(), 0L), TimeUnit.MILLISECONDS) >= (long)this.globalCooldown) {
                                    if (!lastSentPlayerJoinMe.containsKey(p.getUniqueId()) || TimeUnit.SECONDS.convert(System.currentTimeMillis() - lastSentPlayerJoinMe.get(p.getUniqueId()).getOrDefault(p.getServer().getInfo().getName(), 0L), TimeUnit.MILLISECONDS) >= (long)this.individualCooldown) {
                                        String code = this.generateRandomCode();
                                        JoinMeInfo info = new JoinMeInfo(p, p.getServer().getInfo(), System.currentTimeMillis() + (long)(this.validTime * 1000));
                                        HashMultimap categories = HashMultimap.create();
                                        Configuration section = this.instance.getSettings().getConfig().getSection("Categories");
                                        section.getKeys().forEach(arg_0 -> JoinMeCommand.lambda$execute$0((Multimap)categories, section, arg_0));
                                        BufferedImage head = this.instance.getSettings().getConfig().getBoolean("General.HeadMode", false) ? this.parseHead(p) : null;
                                        String joinMeCategory = JoinMeAPI.getCategory(p, (Multimap<String, String>)categories);
                                        String displayName = this.instance.getSettings().getConfig().getBoolean("General.DisplayNames.UseBungeeDisplayNames", true) ? p.getDisplayName() : this.getPrefixByPermission(p) + p.getName();
                                        JoinMeAPI.sendJoinMe(new JoinMeMessage(ProxyServer.getInstance().getPlayers(), JoinMeAPI.replaceVariables(p, (List<String>)this.instance.getSettings().getConfig().getStringList("General.Message"), displayName, joinMeCategory), this.instance.getSettings().getConfig().getString("General.Seperator.Header", KEY_NOT_FOUND), this.instance.getSettings().getConfig().getString("General.Seperator.Footer", KEY_NOT_FOUND), this.instance.getSettings().getConfig().getBoolean("General.Seperator.Show", false), this.instance.getSettings().getConfig().getString("General.MessageSettings.Prefix", KEY_NOT_FOUND), head == null && this.instance.getSettings().getConfig().getBoolean("General.MessageSettings.ShowPrefix", false), JoinMeAPI.replaceVariables(p, this.instance.getSettings().getConfig().getString("General.HoverMessage.Message", KEY_NOT_FOUND), displayName, joinMeCategory), this.instance.getSettings().getConfig().getBoolean("General.HoverMessage.Show", false), head, this.instance.getSettings().getConfig().getInt("General.HeadSettings.GridSize", 8), this.instance.getSettings().getConfig().getString("General.HeadSettings.HeadChar", "\u2593").charAt(0)), new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.getName() + " " + code));
                                        JoinMeCommand.addJoinMeCode(p, code, info);
                                        if (this.instance.getSettings().getConfig().getBoolean("Messages.JoinMeCommand.Success.Enabled", true)) {
                                            sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.JoinMeCommand.Success.Message", KEY_NOT_FOUND))));
                                        }
                                        if (this.clearCacheMethod != ClearCacheMethod.IMMEDIATELY) break;
                                        this.timedClearCacheMethodTask = this.instance.getProxy().getScheduler().schedule((Plugin)this.instance, () -> {
                                            Object object = LOCK;
                                            synchronized (object) {
                                                CODES.remove(code);
                                                lastSentPlayerJoinMe.get(p.getUniqueId()).remove(info.getServer().getName());
                                            }
                                        }, (long)this.validTime, TimeUnit.SECONDS);
                                        break;
                                    }
                                    sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.Cooldown.Individual", KEY_NOT_FOUND).replace("%cooldown%", Integer.toString(this.individualCooldown)))));
                                    break;
                                }
                                sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.Cooldown.Global", KEY_NOT_FOUND).replace("%cooldown%", Integer.toString(this.globalCooldown)))));
                            }
                            catch (Exception e) {
                                sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.JoinMeCommand.Failure.Error", KEY_NOT_FOUND))));
                            }
                            break;
                        }
                        sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.JoinMeCommand.Failure." + (this.instance.getSettings().getConfig().getBoolean("Servers.UseWhitelist", false) ? "Whitelist" : "Blacklist"), KEY_NOT_FOUND))));
                        break;
                    }
                    sender.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.RED + "This command can only be used by players!")));
                    break;
                }
                if (this.instance.getSettings().getConfig().getBoolean("Messages.Credit.Enabled", true)) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.YELLOW + "JoinMe " + ChatColor.GRAY + "v" + this.instance.getDescription().getVersion() + " by " + ChatColor.DARK_AQUA + "Fabb111")));
                    break;
                }
                sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.NoPermission", KEY_NOT_FOUND))));
                break;
            }
            case 1: {
                if (args[0].equalsIgnoreCase("reload") && sender.hasPermission(this.instance.getSettings().getConfig().getString("Permissions.Reload", "joinme.reload"))) {
                    sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.ReloadCommand.Start", KEY_NOT_FOUND))));
                    if (this.instance.reloadConfig()) {
                        sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.ReloadCommand.Success", KEY_NOT_FOUND))));
                        break;
                    }
                    sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.ReloadCommand.Failure", KEY_NOT_FOUND))));
                    break;
                }
                if (sender instanceof ProxiedPlayer) {
                    ProxiedPlayer p = (ProxiedPlayer)sender;
                    JoinMeInfo info = CODES.getOrDefault(args[0], null);
                    if (info != null) {
                        if (Objects.equals(p, info.getSender())) {
                            if (info.getValidUntil() >= System.currentTimeMillis()) {
                                sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.JoinMeValid", KEY_NOT_FOUND).replace("%sec%", Long.toString(TimeUnit.SECONDS.convert(info.getValidUntil() - System.currentTimeMillis(), TimeUnit.MILLISECONDS) + 1L)))));
                                break;
                            }
                            sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.JoinMeInvalid", KEY_NOT_FOUND))));
                            break;
                        }
                        if (info.getValidUntil() >= System.currentTimeMillis()) {
                            if (info.getSender() != null && info.getSender().getServer().getInfo().getName().equals(info.getServer().getName())) {
                                if (!p.getServer().getInfo().getName().equals(info.getServer().getName())) {
                                    p.connect(info.getServer(), (success, error) -> {
                                        if (success.booleanValue()) {
                                            if (this.instance.getSettings().getConfig().getBoolean("Messages.Join.Clicker.SuccessMessage.Enabled", true)) {
                                                sender.sendMessage(JoinMeCommand.toLegacy(JoinMeCommand.replaceVariables(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.Join.Clicker.SuccessMessage.Message", KEY_NOT_FOUND)), info)));
                                            }
                                            if (this.instance.getSettings().getConfig().getBoolean("Messages.Join.Sender.JoinedMessage.Enabled", true)) {
                                                info.getSender().sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.Join.Sender.JoinedMessage.Message", KEY_NOT_FOUND).replace("%displayName%", p.getDisplayName()))));
                                            }
                                        } else if (this.instance.getSettings().getConfig().getBoolean("Messages.Join.Clicker.FailureMessage.Enabled", true)) {
                                            sender.sendMessage(JoinMeCommand.toLegacy(JoinMeCommand.replaceVariables(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.Join.Clicker.FailureMessage.Message", KEY_NOT_FOUND)), info)));
                                        }
                                    });
                                } else {
                                    sender.sendMessage(JoinMeCommand.toLegacy(JoinMeCommand.replaceVariables(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.AlreadyConnected", KEY_NOT_FOUND)), info)));
                                }
                                return;
                            }
                            sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.PlayerLeftServer", KEY_NOT_FOUND))));
                        } else {
                            sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.UnknownJoinCode", KEY_NOT_FOUND))));
                        }
                        CODES.remove(args[0]);
                        break;
                    }
                    sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.UnknownJoinCode", KEY_NOT_FOUND))));
                    break;
                }
                sender.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.RED + "This command can only be used by players!")));
                break;
            }
            default: {
                sender.sendMessage(JoinMeCommand.toLegacy(this.replacePrefix(this.instance.getSettings().getConfig().getString("Messages.UnknownSubcommand", KEY_NOT_FOUND))));
            }
        }
    }

    private static void addJoinMeCode(ProxiedPlayer p, String code, JoinMeInfo info) {
        CODES.put(code, info);
        lastSentGlobalJoinMe.put(info.getServer().getName(), System.currentTimeMillis());
        if (!lastSentPlayerJoinMe.containsKey(p.getUniqueId())) {
            lastSentPlayerJoinMe.put(p.getUniqueId(), new HashMap());
        }
        Map<String, Long> playerJoinMe = lastSentPlayerJoinMe.get(p.getUniqueId());
        playerJoinMe.put(info.getServer().getName(), System.currentTimeMillis());
    }

    private static boolean containsServer(List<String> serverRegexes, String serverName) {
        boolean contains = false;
        Iterator<String> i = serverRegexes.iterator();
        while (i.hasNext() && !contains) {
            String serverRegex = i.next();
            contains = serverName.matches(serverRegex);
        }
        return contains;
    }

    private static String replaceVariables(String s, JoinMeInfo info) {
        return s.replace("%server%", info.getServer().getName()).replace("%displayName%", info.getSender().getDisplayName());
    }

    private static BaseComponent[] toLegacy(String s) {
        return TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)s));
    }

    private String getPrefixByPermission(ProxiedPlayer p) {
        String prefix = null;
        Configuration section = this.instance.getSettings().getConfig().getSection("General.DisplayNames.Prefixes");
        Iterator i = section.getKeys().iterator();
        while (i.hasNext() && prefix == null) {
            String key = (String)i.next();
            if (!p.hasPermission(section.getString(key + ".Permission"))) continue;
            prefix = section.getString(key + ".Prefix");
        }
        return prefix == null ? "" : prefix;
    }

    private void startTimedClearCacheMethod() {
        int delay = this.instance.getSettings().getConfig().getInt("Cache.Delay", 600);
        this.timedClearCacheMethodTask = this.instance.getProxy().getScheduler().schedule((Plugin)this.instance, () -> {
            Object object = LOCK;
            synchronized (object) {
                long currentTime = System.currentTimeMillis();
                Iterator<Map.Entry<String, JoinMeInfo>> codeIterator = CODES.entrySet().iterator();
                while (codeIterator.hasNext()) {
                    Map.Entry<String, JoinMeInfo> e = codeIterator.next();
                    if (e.getValue().getValidUntil() >= currentTime) continue;
                    codeIterator.remove();
                }
                Iterator<Map.Entry<String, Long>> globalIterator = lastSentGlobalJoinMe.entrySet().iterator();
                while (globalIterator.hasNext()) {
                    Map.Entry<String, Long> e = globalIterator.next();
                    if (TimeUnit.SECONDS.convert(System.currentTimeMillis() - e.getValue(), TimeUnit.MILLISECONDS) < (long)this.globalCooldown) continue;
                    globalIterator.remove();
                }
                Iterator<Map<String, Long>> playerIterator = lastSentPlayerJoinMe.values().iterator();
                while (playerIterator.hasNext()) {
                    Map<String, Long> playerCooldowns = playerIterator.next();
                    Iterator<Map.Entry<String, Long>> innerPlayerIterator = playerCooldowns.entrySet().iterator();
                    while (innerPlayerIterator.hasNext()) {
                        Map.Entry<String, Long> ie = innerPlayerIterator.next();
                        if (TimeUnit.SECONDS.convert(System.currentTimeMillis() - ie.getValue(), TimeUnit.MILLISECONDS) < (long)this.individualCooldown) continue;
                        innerPlayerIterator.remove();
                    }
                    if (!playerCooldowns.isEmpty()) continue;
                    playerIterator.remove();
                }
            }
        }, (long)delay, (long)delay, TimeUnit.SECONDS);
    }

    public void stopTimedClearCacheMethod() {
        this.timedClearCacheMethodTask.cancel();
    }

    private BufferedImage parseHead(ProxiedPlayer p) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.instance.getSettings().getConfig().getBoolean("General.HeadSettings.HeadAPI.UUID.Use", true) ? (this.instance.getSettings().getConfig().getBoolean("General.HeadSettings.HeadAPI.UUID.Trim", false) ? p.getUniqueId().toString().replace("-", "") : p.getUniqueId().toString()) : p.getName();
        String request = String.format(this.instance.getSettings().getConfig().getString("General.HeadSettings.HeadAPI.URL", "https://crafatar.com/avatars/%s"), objectArray);
        try {
            return ImageIO.read(new URL(request));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(JoinMeCommand.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            this.instance.getLog().warn("Head of player " + p.getName() + " could not be parsed!");
        }
        return null;
    }

    private String replacePrefix(String s) {
        return s.replace("%prefix%", this.instance.getSettings().getConfig().getString("General.Prefix", KEY_NOT_FOUND));
    }

    private String generateRandomCode() {
        Random r = new Random();
        StringBuilder b = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            b.append(this.charset.charAt(r.nextInt(this.charset.length())));
        }
        return b.toString();
    }

    private static /* synthetic */ void lambda$execute$0(Multimap categories, Configuration section, String key) {
        categories.putAll((Object)key, (Iterable)section.getStringList(key));
    }

    private static enum ClearCacheMethod {
        NEVER,
        IMMEDIATELY,
        TIMED;

    }

    private class JoinMeInfo {
        private final ProxiedPlayer sender;
        private final ServerInfo server;
        private final long validUntil;

        @ConstructorProperties(value={"sender", "server", "validUntil"})
        public JoinMeInfo(ProxiedPlayer sender, ServerInfo server, long validUntil) {
            this.sender = sender;
            this.server = server;
            this.validUntil = validUntil;
        }

        public ProxiedPlayer getSender() {
            return this.sender;
        }

        public ServerInfo getServer() {
            return this.server;
        }

        public long getValidUntil() {
            return this.validUntil;
        }
    }
}

